/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.multipart;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.Charsets;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.server.internal.multipart.MalformedBodyException;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.inverno.mod.http.server.internal.multipart.UrlEncodedParameter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpConstants;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.SignalType;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class UrlEncodedBodyDecoder
implements MultipartDecoder<Parameter> {
    private ObjectConverter<String> parameterConverter;

    public UrlEncodedBodyDecoder(ObjectConverter<String> parameterConverter) {
        this.parameterConverter = parameterConverter;
    }

    @Override
    public Flux<Parameter> decode(Flux<ByteBuf> data, Headers.ContentType contentType) {
        if (contentType == null || !contentType.getMediaType().equalsIgnoreCase("application/x-www-form-urlencoded")) {
            throw new IllegalArgumentException("Content type is not application/x-www-form-urlencoded");
        }
        return Flux.create(emitter -> data.subscribe((CoreSubscriber)new BodyDataSubscriber(contentType, (FluxSink<Parameter>)emitter)));
    }

    private UrlEncodedParameter readParameter(ByteBuf buffer, Charset charset) throws MalformedBodyException {
        if (charset == null) {
            charset = HttpConstants.DEFAULT_CHARSET;
        }
        int readerIndex = buffer.readerIndex();
        Integer startIndex = null;
        Integer endIndex = null;
        String parameterName = null;
        while (buffer.isReadable()) {
            byte nextByte = buffer.readByte();
            if (nextByte == 13) {
                if (!buffer.isReadable()) continue;
                if (buffer.readByte() == 10) {
                    endIndex = buffer.readerIndex() - 2;
                    if (parameterName != null) {
                        return new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(parameterName, charset), this.decodeComponent(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), charset), false, true);
                    }
                    if (startIndex != null) {
                        return new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), charset), "", false, true);
                    }
                    return new UrlEncodedParameter(this.parameterConverter, "", "", true, true);
                }
                buffer.readerIndex(readerIndex);
                throw new MalformedBodyException("Bad end of line");
            }
            if (nextByte == 10) {
                endIndex = buffer.readerIndex() - 1;
                if (parameterName != null) {
                    return new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(parameterName, charset), this.decodeComponent(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), charset), false, true);
                }
                if (startIndex != null) {
                    return new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), charset), "", false, true);
                }
                return new UrlEncodedParameter(this.parameterConverter, "", "", true, true);
            }
            if (parameterName == null) {
                if (startIndex == null) {
                    startIndex = buffer.readerIndex() - 1;
                }
                if (nextByte == 61) {
                    endIndex = buffer.readerIndex() - 1;
                    parameterName = buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString();
                    endIndex = null;
                    startIndex = null;
                    continue;
                }
                if (nextByte != 38) continue;
                if (startIndex < buffer.readerIndex() - 1) {
                    endIndex = buffer.readerIndex() - 1;
                    return new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), charset), "", false, false);
                }
                startIndex = null;
                continue;
            }
            if (startIndex == null) {
                startIndex = buffer.readerIndex() - 1;
            }
            if (nextByte != 38) continue;
            endIndex = buffer.readerIndex() - 1;
            return new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(parameterName, charset), this.decodeComponent(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), charset), false, false);
        }
        if (parameterName != null) {
            if (startIndex == null) {
                UrlEncodedParameter partialParameter = new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(parameterName, charset), "", true, false);
                buffer.readerIndex(readerIndex);
                return partialParameter;
            }
            endIndex = buffer.readerIndex();
            UrlEncodedParameter partialParameter = new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(parameterName, charset), this.decodeComponent(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), charset), true, false);
            buffer.readerIndex(readerIndex);
            return partialParameter;
        }
        if (startIndex != null && startIndex < buffer.readerIndex()) {
            endIndex = buffer.readerIndex();
            UrlEncodedParameter partialParameter = new UrlEncodedParameter(this.parameterConverter, this.decodeComponent(buffer.getCharSequence(startIndex.intValue(), endIndex - startIndex, charset).toString(), charset), "", true, false);
            buffer.readerIndex(readerIndex);
            return partialParameter;
        }
        buffer.readerIndex(readerIndex);
        return null;
    }

    private String decodeComponent(String value, Charset charset) throws MalformedBodyException {
        try {
            return URLDecoder.decode(value, charset.toString());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            throw new MalformedBodyException(e);
        }
    }

    private class BodyDataSubscriber
    extends BaseSubscriber<ByteBuf> {
        private final Charset charset;
        private final FluxSink<Parameter> emitter;
        private ByteBuf keepBuffer;
        private UrlEncodedParameter partialParameter;

        public BodyDataSubscriber(Headers.ContentType contentType, FluxSink<Parameter> emitter) {
            this.charset = Charsets.orDefault((Charset)contentType.getCharset());
            this.emitter = emitter;
            this.emitter.onCancel(() -> this.cancel());
        }

        private void emitPartialParameter() {
            if (this.partialParameter != null && !this.partialParameter.isLast()) {
                this.partialParameter.setPartial(false);
                this.partialParameter.setLast(true);
                this.emitter.next((Object)this.partialParameter);
            }
        }

        protected void hookOnNext(ByteBuf value) {
            try {
                ByteBuf buffer = this.keepBuffer != null && this.keepBuffer.isReadable() ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.keepBuffer, value}) : value;
                UrlEncodedParameter nextParameter = null;
                while ((nextParameter = UrlEncodedBodyDecoder.this.readParameter(buffer, this.charset)) != null) {
                    if (nextParameter.isLast()) {
                        if (!nextParameter.isPartial()) {
                            this.emitter.next((Object)nextParameter);
                        }
                        if (buffer.isReadable()) {
                            this.emitter.error((Throwable)((Object)new MalformedBodyException("Data received after body was fully decoded")));
                        } else {
                            this.emitter.complete();
                        }
                        this.cancel();
                        return;
                    }
                    if (nextParameter.isPartial()) {
                        this.partialParameter = nextParameter;
                        break;
                    }
                    this.emitter.next((Object)nextParameter);
                }
                if (buffer.isReadable()) {
                    if (this.keepBuffer != null) {
                        this.keepBuffer.discardReadBytes();
                        this.keepBuffer.writeBytes(buffer);
                    } else {
                        this.keepBuffer = buffer.alloc().buffer(buffer.readableBytes());
                        this.keepBuffer.writeBytes(buffer);
                    }
                }
            }
            catch (Exception e) {
                this.emitter.error((Throwable)e);
                this.cancel();
            }
        }

        protected void hookOnError(Throwable throwable) {
            this.emitPartialParameter();
            this.emitter.error(throwable);
        }

        protected void hookOnComplete() {
            this.emitPartialParameter();
            if (this.keepBuffer != null && this.keepBuffer.isReadable() && this.keepBuffer.getByte(this.keepBuffer.readableBytes() - 1) == 13) {
                this.emitter.error((Throwable)((Object)new MalformedBodyException("Bad end of line")));
            }
            this.emitter.complete();
        }

        protected void hookFinally(SignalType type) {
            if (this.keepBuffer != null) {
                this.keepBuffer.release();
                this.keepBuffer = null;
            }
        }
    }
}

