/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.multipart;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.InboundCookies;
import io.inverno.mod.http.base.InboundRequestHeaders;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class PartHeaders
implements InboundRequestHeaders {
    private final ObjectConverter<String> parameterConverter;
    private final Map<String, List<? extends Header>> headers;

    public PartHeaders(Map<String, List<Header>> headers, ObjectConverter<String> parameterConverter) {
        this.parameterConverter = parameterConverter;
        this.headers = headers != null ? Collections.unmodifiableMap(headers) : Map.of();
    }

    public String getContentType() {
        return Optional.ofNullable(this.headers.get("content-type")).filter(l -> !l.isEmpty()).map(l -> ((Header)l.get(0)).getHeaderValue()).orElse(null);
    }

    public Headers.ContentType getContentTypeHeader() {
        return Optional.ofNullable(this.headers.get("content-type")).filter(l -> !l.isEmpty()).map(l -> (Header)l.get(0)).orElse(null);
    }

    public Long getContentLength() {
        return Optional.ofNullable(this.headers.get("content-length")).filter(l -> !l.isEmpty()).map(l -> ((Header)l.get(0)).getHeaderValue()).map(Long::parseLong).orElse(null);
    }

    public InboundCookies cookies() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(CharSequence name) {
        return this.headers.containsKey(name.toString());
    }

    public boolean contains(CharSequence name, CharSequence value) {
        List<? extends Header> allHeaders = this.headers.get(name.toString());
        if (allHeaders != null) {
            for (Header header : allHeaders) {
                if (!header.getHeaderValue().equalsIgnoreCase(value.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getNames() {
        return this.headers.keySet();
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.headers.get(name.toString())).map(allHeaders -> {
            if (!allHeaders.isEmpty()) {
                return ((Header)allHeaders.get(0)).getHeaderValue();
            }
            return null;
        });
    }

    public List<String> getAll(CharSequence name) {
        List<? extends Header> allHeaders = this.headers.get(name.toString());
        if (allHeaders != null) {
            return allHeaders.stream().map(h -> h.getHeaderValue()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Map.Entry<String, String>> getAll() {
        return this.headers.values().stream().flatMap(l -> l.stream().map(h -> Map.entry(h.getHeaderName(), h.getHeaderValue()))).collect(Collectors.toList());
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return Optional.ofNullable(this.headers.get(name.toString())).map(allHeaders -> {
            if (!allHeaders.isEmpty()) {
                return (Header)allHeaders.get(0);
            }
            return null;
        });
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        List<? extends Header> allHeaders = this.headers.get(name.toString());
        if (allHeaders != null) {
            return allHeaders.stream().map(header -> header).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Header> getAllHeader() {
        return this.headers.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return Optional.ofNullable(this.headers.get(name.toString())).map(allHeaders -> {
            if (!allHeaders.isEmpty()) {
                return new GenericParameter(((Header)allHeaders.get(0)).getHeaderName(), ((Header)allHeaders.get(0)).getHeaderValue(), this.parameterConverter);
            }
            return null;
        });
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        List<? extends Header> allHeaders = this.headers.get(name.toString());
        if (allHeaders != null) {
            return allHeaders.stream().map(h -> new GenericParameter(h.getHeaderName(), h.getHeaderValue(), this.parameterConverter)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Parameter> getAllParameter() {
        return this.headers.values().stream().flatMap(l -> l.stream().map(h -> new GenericParameter(h.getHeaderName(), h.getHeaderValue(), this.parameterConverter))).collect(Collectors.toList());
    }
}

