/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import com.aayushatharva.brotli4j.encoder.Encoder;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.http2.Http2Connection;
import io.inverno.mod.http.server.internal.http2.Http2ContentEncodingResolver;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class Http2ConnectionFactory
implements Supplier<Http2Connection> {
    private final HttpServerConfiguration configuration;
    private final ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private final CompressionOptions[] compressionOptions;

    public Http2ConnectionFactory(HttpServerConfiguration configuration, ServerController<?, ? extends Exchange<?>, ? extends ErrorExchange<?>> controller, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        this.configuration = configuration;
        this.controller = controller;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        ArrayList<Object> compressionOptionsList = new ArrayList<Object>();
        compressionOptionsList.add(StandardCompressionOptions.deflate((int)this.configuration.compression_deflate_compressionLevel(), (int)this.configuration.compression_deflate_windowBits(), (int)this.configuration.compression_deflate_memLevel()));
        compressionOptionsList.add(StandardCompressionOptions.gzip((int)this.configuration.compression_gzip_compressionLevel(), (int)this.configuration.compression_gzip_windowBits(), (int)this.configuration.compression_gzip_memLevel()));
        if (Zstd.isAvailable()) {
            compressionOptionsList.add(StandardCompressionOptions.zstd((int)this.configuration.compression_zstd_compressionLevel(), (int)this.configuration.compression_zstd_blockSize(), (int)this.configuration.compression_zstd_maxEncodeSize()));
        }
        if (Brotli.isAvailable()) {
            compressionOptionsList.add(StandardCompressionOptions.brotli((Encoder.Parameters)new Encoder.Parameters().setQuality(this.configuration.compression_brotli_quality()).setMode(Encoder.Mode.of((int)this.configuration.compression_brotli_mode())).setWindow(this.configuration.compression_brotli_window())));
        }
        this.compressionOptions = (CompressionOptions[])compressionOptionsList.stream().toArray(CompressionOptions[]::new);
    }

    @Override
    public Http2Connection get() {
        return new Http2ChannelHandlerBuilder().build();
    }

    private class Http2ChannelHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<Http2Connection, Http2ChannelHandlerBuilder> {
        public Http2ChannelHandlerBuilder() {
            Http2Settings initialSettings = this.initialSettings();
            Optional.ofNullable(Http2ConnectionFactory.this.configuration.http2_header_table_size()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).headerTableSize(arg_0));
            Optional.ofNullable(Http2ConnectionFactory.this.configuration.http2_max_concurrent_streams()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).maxConcurrentStreams(arg_0));
            Optional.ofNullable(Http2ConnectionFactory.this.configuration.http2_initial_window_size()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).initialWindowSize(arg_0));
            Optional.ofNullable(Http2ConnectionFactory.this.configuration.http2_max_frame_size()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).maxFrameSize(arg_0));
            Optional.ofNullable(Http2ConnectionFactory.this.configuration.http2_max_header_list_size()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).maxHeaderListSize(arg_0));
        }

        protected Http2Connection build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
            Http2ContentEncodingResolver contentEncodingResolver = null;
            if (Http2ConnectionFactory.this.configuration.compression_enabled()) {
                encoder = new CompressorHttp2ConnectionEncoder(encoder, Http2ConnectionFactory.this.compressionOptions);
                contentEncodingResolver = new Http2ContentEncodingResolver(Http2ConnectionFactory.this.compressionOptions);
            }
            Http2Connection handler = new Http2Connection(Http2ConnectionFactory.this.configuration, decoder, encoder, initialSettings, Http2ConnectionFactory.this.controller, Http2ConnectionFactory.this.headerService, Http2ConnectionFactory.this.parameterConverter, Http2ConnectionFactory.this.urlEncodedBodyDecoder, Http2ConnectionFactory.this.multipartBodyDecoder, contentEncodingResolver);
            this.frameListener(handler);
            return handler;
        }

        public Http2Connection build() {
            return (Http2Connection)super.build();
        }
    }
}

