/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.URIBuilder;
import io.inverno.mod.base.net.URIs;
import io.inverno.mod.http.base.InboundRequestHeaders;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.AbstractRequest;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import java.util.Optional;
import reactor.core.publisher.Sinks;

class Http1xRequest
extends AbstractRequest {
    private final HttpRequest underlyingRequest;
    private URIBuilder pathBuilder;
    private Method method;
    private String scheme;
    private String authority;

    public Http1xRequest(ChannelHandlerContext context, HttpRequest httpRequest, InboundRequestHeaders requestHeaders, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        super(context, requestHeaders, parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder);
        this.underlyingRequest = httpRequest;
    }

    HttpRequest getUnderlyingRequest() {
        return this.underlyingRequest;
    }

    @Override
    protected URIBuilder getPrimaryPathBuilder() {
        if (this.pathBuilder == null) {
            this.pathBuilder = URIs.uri((String)this.underlyingRequest.uri(), (boolean)false, (URIs.Option[])new URIs.Option[]{URIs.Option.NORMALIZED});
        }
        return this.pathBuilder;
    }

    @Override
    public Optional<Sinks.Many<ByteBuf>> data() {
        this.body();
        return super.data();
    }

    public Method getMethod() {
        if (this.method == null) {
            try {
                this.method = Method.valueOf((String)this.underlyingRequest.method().name());
            }
            catch (IllegalArgumentException e) {
                this.method = Method.UNKNOWN;
            }
        }
        return this.method;
    }

    @Override
    public String getScheme() {
        if (this.scheme == null) {
            this.scheme = this.context.pipeline().get(SslHandler.class) != null ? "https" : "http";
        }
        return this.scheme;
    }

    public String getAuthority() {
        if (this.authority == null) {
            this.authority = this.requestHeaders.get((CharSequence)"host").orElse(null);
        }
        return this.authority;
    }

    public String getPath() {
        return this.underlyingRequest.uri();
    }
}

