/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.http.server.internal.HttpServerChannelConfigurer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;

public class HttpProtocolNegotiationHandler
extends ApplicationProtocolNegotiationHandler {
    private final HttpServerChannelConfigurer channelConfigurer;

    public HttpProtocolNegotiationHandler(HttpServerChannelConfigurer channelConfigurer) {
        super("http/1.1");
        this.channelConfigurer = channelConfigurer;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        ChannelPipeline pipeline = ctx.pipeline();
        if ("h2".equals(protocol)) {
            this.channelConfigurer.configureHttp2(pipeline);
        } else if ("http/1.1".equals(protocol)) {
            this.channelConfigurer.configureHttp1x(pipeline);
        } else {
            throw new IllegalStateException("Unsupported protocol: " + protocol);
        }
    }
}

