package io.inverno.mod.http.server;

import io.inverno.core.v1.Module;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.NetService;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.http.base.Base;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.header.HeaderCodec;
import io.inverno.mod.http.server.internal.HttpServer;
import io.inverno.mod.http.server.internal.HttpServerChannelConfigurer;
import io.inverno.mod.http.server.internal.HttpServerChannelInitializer;
import io.inverno.mod.http.server.internal.HttpServerController;
import io.inverno.mod.http.server.internal.ParameterConverter;
import io.inverno.mod.http.server.internal.SslCipherSuiteFilter;
import io.inverno.mod.http.server.internal.SslContextWrapper;
import io.inverno.mod.http.server.internal.http1x.Http1xConnectionFactory;
import io.inverno.mod.http.server.internal.http2.Http2ConnectionFactory;
import io.inverno.mod.http.server.internal.multipart.MultipartFormDataBodyDecoder;
import io.inverno.mod.http.server.internal.multipart.UrlEncodedBodyDecoder;
import io.netty.handler.ssl.SslContext;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;

@Generated(value= {"io.inverno.core.compiler.InvernoCompiler", "1"}, date = "2024-01-23T21:32:51.908020202+01:00[Europe/Paris]")
public final class Server extends Module {

	private Base base;

	private Bean<HttpServerConfiguration> configuration;
	private Bean<ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>>> controller;
	private Bean<Http1xConnectionFactory> http1xConnectionFactory;
	private Bean<Http2ConnectionFactory> http2ConnectionFactory;
	private Bean<HttpServer> httpServer;
	private Bean<HttpServerChannelConfigurer> httpServerChannelConfigurer;
	private Bean<HttpServerChannelInitializer> httpServerChannelInitializer;
	private Bean<MultipartFormDataBodyDecoder> multipartFormDataBodyDecoder;
	private Bean<ObjectConverter<String>> parameterConverter;
	private Bean<SslCipherSuiteFilter> sslCipherSuiteFilter;
	private Bean<SslContext> sslContextWrapper;
	private Bean<UrlEncodedBodyDecoder> urlEncodedBodyDecoder;

	private Server(
			@Socket(name = "headerCodecs", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerChannelConfigurer", "httpServer", "http1xConnectionFactory", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "configuration", "http2ConnectionFactory", "httpServerChannelInitializer", "sslContextWrapper"}) Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs,
			@Socket(name = "netService", wiredTo = {"multipartFormDataBodyDecoder", "httpServerChannelConfigurer", "parameterConverter", "httpServer", "http1xConnectionFactory", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "configuration", "http2ConnectionFactory", "httpServerChannelInitializer", "sslContextWrapper"}) Supplier<NetService> netService,
			@Socket(name = "resourceService", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerChannelConfigurer", "httpServer", "http1xConnectionFactory", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "configuration", "http2ConnectionFactory", "httpServerChannelInitializer", "sslContextWrapper"}) Supplier<ResourceService> resourceService,
			@Socket(name = "configuration", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerChannelConfigurer", "httpServer", "http1xConnectionFactory", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "configuration", "http2ConnectionFactory", "httpServerChannelInitializer", "sslContextWrapper"}) Optional<Supplier<HttpServerConfiguration>> configurationOverride,
			@Socket(name = "controller", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerChannelConfigurer", "httpServer", "http1xConnectionFactory", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "configuration", "http2ConnectionFactory", "httpServerChannelInitializer", "sslContextWrapper"}) Optional<Supplier<ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>>>> controllerOverride,
			@Socket(name = "parameterConverter", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerChannelConfigurer", "httpServer", "http1xConnectionFactory", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "configuration", "http2ConnectionFactory", "httpServerChannelInitializer", "sslContextWrapper"}) Optional<Supplier<ObjectConverter<String>>> parameterConverterOverride
		) {
		super("io.inverno.mod.http.server");

		this.base = this.with(new Base.Linker(Map.ofEntries(
			Map.entry("headerCodecs", Optional.of((Supplier<List<HeaderCodec<?>>>)() -> new BeanAggregator<HeaderCodec<?>>()
					.add(headerCodecs.orElse(() -> null).get())
				.toList())),
			Map.entry("parameterConverter", Optional.of((Supplier<ObjectConverter<String>>)() -> this.parameterConverter.get()))
		)));

		this.configuration = this.with(WrapperBeanBuilder
			.singleton("configuration", () -> {
				io.inverno.mod.http.server.HttpServerConfigurationLoader.Bean configuration = new io.inverno.mod.http.server.HttpServerConfigurationLoader.Bean();

				return configuration;
			})
			.override(configurationOverride)
		);
		this.controller = this.with(WrapperBeanBuilder
			.singleton("controller", () -> {
				HttpServerController controller = new HttpServerController();

				return controller;
			})
			.override(controllerOverride)
		);
		this.http1xConnectionFactory = this.with(ModuleBeanBuilder
			.singleton("http1xConnectionFactory", () -> {
				Http1xConnectionFactory http1xConnectionFactory = new Http1xConnectionFactory(
					this.configuration.get(),
					this.controller.get(),
					this.base.headerService(),
					this.parameterConverter.get(),
					this.urlEncodedBodyDecoder.get(),
					this.multipartFormDataBodyDecoder.get()
				);

				return http1xConnectionFactory;
			})
		);
		this.http2ConnectionFactory = this.with(ModuleBeanBuilder
			.singleton("http2ConnectionFactory", () -> {
				Http2ConnectionFactory http2ConnectionFactory = new Http2ConnectionFactory(
					this.configuration.get(),
					this.controller.get(),
					this.base.headerService(),
					this.parameterConverter.get(),
					this.urlEncodedBodyDecoder.get(),
					this.multipartFormDataBodyDecoder.get()
				);

				return http2ConnectionFactory;
			})
		);
		this.httpServer = this.with(ModuleBeanBuilder
			.singleton("httpServer", () -> {
				HttpServer httpServer = new HttpServer(
					this.configuration.get(),
					netService.get(),
					this.httpServerChannelInitializer.get()
				);

				return httpServer;
			})
			.init(HttpServer::start)
			.destroy(HttpServer::stop)
		);
		this.httpServerChannelConfigurer = this.with(ModuleBeanBuilder
			.singleton("httpServerChannelConfigurer", () -> {
				HttpServerChannelConfigurer httpServerChannelConfigurer = new HttpServerChannelConfigurer(
					this.configuration.get(),
					netService.get(),
					() -> this.sslContextWrapper.get(),
					this.http1xConnectionFactory.get(),
					this.http2ConnectionFactory.get()
				);

				return httpServerChannelConfigurer;
			})
		);
		this.httpServerChannelInitializer = this.with(ModuleBeanBuilder
			.singleton("httpServerChannelInitializer", () -> {
				HttpServerChannelInitializer httpServerChannelInitializer = new HttpServerChannelInitializer(
					this.httpServerChannelConfigurer.get()
				);

				return httpServerChannelInitializer;
			})
		);
		this.multipartFormDataBodyDecoder = this.with(ModuleBeanBuilder
			.singleton("multipartFormDataBodyDecoder", () -> {
				MultipartFormDataBodyDecoder multipartFormDataBodyDecoder = new MultipartFormDataBodyDecoder(
					this.base.headerService(),
					this.parameterConverter.get()
				);

				return multipartFormDataBodyDecoder;
			})
		);
		this.parameterConverter = this.with(WrapperBeanBuilder
			.singleton("parameterConverter", () -> {
				ParameterConverter parameterConverter = new ParameterConverter();

				return parameterConverter;
			})
			.override(parameterConverterOverride)
		);
		this.sslCipherSuiteFilter = this.with(ModuleBeanBuilder
			.singleton("sslCipherSuiteFilter", () -> {
				SslCipherSuiteFilter sslCipherSuiteFilter = new SslCipherSuiteFilter(
					this.configuration.get()
				);

				return sslCipherSuiteFilter;
			})
		);
		this.sslContextWrapper = this.with(WrapperBeanBuilder
			.prototype("sslContextWrapper", () -> {
				SslContextWrapper sslContextWrapper = new SslContextWrapper(
					this.configuration.get(),
					resourceService.get()
				);
				Optional.of(this.sslCipherSuiteFilter.get()).ifPresent(sslContextWrapper::setCipherSuiteFilter);
				return sslContextWrapper;
			})
			.init(SslContextWrapper::init)
		);
		this.urlEncodedBodyDecoder = this.with(ModuleBeanBuilder
			.singleton("urlEncodedBodyDecoder", () -> {
				UrlEncodedBodyDecoder urlEncodedBodyDecoder = new UrlEncodedBodyDecoder(
					this.parameterConverter.get()
				);

				return urlEncodedBodyDecoder;
			})
		);
	}

	public HttpServerConfiguration configuration() {
		return this.configuration.get();
	}

	public ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>> controller() {
		return this.controller.get();
	}

	private Http1xConnectionFactory http1xConnectionFactory() {
		return this.http1xConnectionFactory.get();
	}

	private Http2ConnectionFactory http2ConnectionFactory() {
		return this.http2ConnectionFactory.get();
	}

	private HttpServer httpServer() {
		return this.httpServer.get();
	}

	private HttpServerChannelConfigurer httpServerChannelConfigurer() {
		return this.httpServerChannelConfigurer.get();
	}

	private HttpServerChannelInitializer httpServerChannelInitializer() {
		return this.httpServerChannelInitializer.get();
	}

	private MultipartFormDataBodyDecoder multipartFormDataBodyDecoder() {
		return this.multipartFormDataBodyDecoder.get();
	}

	private ObjectConverter<String> parameterConverter() {
		return this.parameterConverter.get();
	}

	private SslCipherSuiteFilter sslCipherSuiteFilter() {
		return this.sslCipherSuiteFilter.get();
	}

	private SslContext sslContextWrapper() {
		return this.sslContextWrapper.get();
	}

	private UrlEncodedBodyDecoder urlEncodedBodyDecoder() {
		return this.urlEncodedBodyDecoder.get();
	}

	public static final class Builder extends ModuleBuilder<Server> {

		private Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs = Optional.empty();
		private Supplier<NetService> netService;
		private Supplier<ResourceService> resourceService;
		private Optional<Supplier<HttpServerConfiguration>> configuration = Optional.empty();
		private Optional<Supplier<ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>>>> controller = Optional.empty();
		private Optional<Supplier<ObjectConverter<String>>> parameterConverter = Optional.empty();

		public Builder(NetService netService, ResourceService resourceService) {
			super("netService", netService, "resourceService", resourceService);

			this.netService = () -> netService;
			this.resourceService = () -> resourceService;
		}

		protected Server doBuild() {
			return new Server(this.headerCodecs, this.netService, this.resourceService, this.configuration, this.controller, this.parameterConverter);
		}

		public Builder setHeaderCodecs(List<HeaderCodec<?>> headerCodecs) {
			this.headerCodecs = Optional.ofNullable(headerCodecs != null ? () -> headerCodecs : null);
			return this;
		}

		public Builder setConfiguration(HttpServerConfiguration configuration) {
			this.configuration = Optional.ofNullable(configuration != null ? () -> configuration : null);
			return this;
		}

		public Builder setController(ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>> controller) {
			this.controller = Optional.ofNullable(controller != null ? () -> controller : null);
			return this;
		}

		public Builder setParameterConverter(ObjectConverter<String> parameterConverter) {
			this.parameterConverter = Optional.ofNullable(parameterConverter != null ? () -> parameterConverter : null);
			return this;
		}
	}

	public static final class Linker extends ModuleLinker<Server> {

		public Linker(Map<String, Object> sockets) {
			super(sockets);
		}

		@SuppressWarnings("unchecked")
		protected Server link() {
			return new Server(
				(Optional<Supplier<List<HeaderCodec<?>>>>)this.sockets.get("headerCodecs"),
				(Supplier<NetService>)this.sockets.get("netService"),
				(Supplier<ResourceService>)this.sockets.get("resourceService"),
				(Optional<Supplier<HttpServerConfiguration>>)this.sockets.get("configuration"),
				(Optional<Supplier<ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>>>>)this.sockets.get("controller"),
				(Optional<Supplier<ObjectConverter<String>>>)this.sockets.get("parameterConverter")
			);
		}
	}
}
