package io.inverno.mod.http.server;

import io.inverno.core.annotation.Overridable;
import io.inverno.core.annotation.Wrapper;
import io.inverno.mod.configuration.ConfigurationKey.Parameter;
import io.inverno.mod.configuration.ConfigurationLoaderSupport;
import io.inverno.mod.configuration.ConfigurationSource;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.String;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;

@Generated(value="io.inverno.mod.configuration.compiler.internal.ConfigurationCompilerPlugin", date = "2024-01-23T21:32:51.707836589+01:00[Europe/Paris]")
public final class HttpServerConfigurationLoader extends ConfigurationLoaderSupport<HttpServerConfiguration, HttpServerConfigurationLoader.Configurator, HttpServerConfigurationLoader> {

	public HttpServerConfigurationLoader() {
		super(
			new String[] {
				"io.inverno.mod.http.server.configuration.server_host",
				"io.inverno.mod.http.server.configuration.server_port",
				"io.inverno.mod.http.server.configuration.server_event_loop_group_size",
				"io.inverno.mod.http.server.configuration.compression_enabled",
				"io.inverno.mod.http.server.configuration.decompression_enabled",
				"io.inverno.mod.http.server.configuration.compression_contentSizeThreshold",
				"io.inverno.mod.http.server.configuration.compression_brotli_quality",
				"io.inverno.mod.http.server.configuration.compression_brotli_window",
				"io.inverno.mod.http.server.configuration.compression_brotli_mode",
				"io.inverno.mod.http.server.configuration.compression_deflate_compressionLevel",
				"io.inverno.mod.http.server.configuration.compression_deflate_windowBits",
				"io.inverno.mod.http.server.configuration.compression_deflate_memLevel",
				"io.inverno.mod.http.server.configuration.compression_gzip_compressionLevel",
				"io.inverno.mod.http.server.configuration.compression_gzip_windowBits",
				"io.inverno.mod.http.server.configuration.compression_gzip_memLevel",
				"io.inverno.mod.http.server.configuration.compression_zstd_blockSize",
				"io.inverno.mod.http.server.configuration.compression_zstd_compressionLevel",
				"io.inverno.mod.http.server.configuration.compression_zstd_maxEncodeSize",
				"io.inverno.mod.http.server.configuration.key_store",
				"io.inverno.mod.http.server.configuration.key_store_type",
				"io.inverno.mod.http.server.configuration.key_store_password",
				"io.inverno.mod.http.server.configuration.tls_enabled",
				"io.inverno.mod.http.server.configuration.tls_handshake_timeout",
				"io.inverno.mod.http.server.configuration.tls_ciphers_includes",
				"io.inverno.mod.http.server.configuration.tls_ciphers_excludes",
				"io.inverno.mod.http.server.configuration.h2c_enabled",
				"io.inverno.mod.http.server.configuration.h2_enabled",
				"io.inverno.mod.http.server.configuration.http2_header_table_size",
				"io.inverno.mod.http.server.configuration.http2_max_concurrent_streams",
				"io.inverno.mod.http.server.configuration.http2_initial_window_size",
				"io.inverno.mod.http.server.configuration.http2_max_frame_size",
				"io.inverno.mod.http.server.configuration.http2_max_header_list_size",
				"io.inverno.mod.http.server.configuration.ws_handshake_timeout",
				"io.inverno.mod.http.server.configuration.ws_close_timeout",
				"io.inverno.mod.http.server.configuration.ws_max_frame_size",
				"io.inverno.mod.http.server.configuration.ws_allow_mask_mismatch",
				"io.inverno.mod.http.server.configuration.ws_frame_compression_enabled",
				"io.inverno.mod.http.server.configuration.ws_frame_compression_level",
				"io.inverno.mod.http.server.configuration.ws_message_compression_enabled",
				"io.inverno.mod.http.server.configuration.ws_message_compression_level",
				"io.inverno.mod.http.server.configuration.ws_message_allow_server_window_size",
				"io.inverno.mod.http.server.configuration.ws_message_prefered_client_window_size",
				"io.inverno.mod.http.server.configuration.ws_message_allow_server_no_context",
				"io.inverno.mod.http.server.configuration.ws_message_preferred_client_no_context",
				"io.inverno.mod.http.server.configuration.ws_close_on_outbound_complete",
				"io.inverno.mod.http.server.configuration.ws_inbound_close_frame_timeout"
			},
			results -> configuration_configurator -> {
				results.get(0).getResult().ifPresent(property -> configuration_configurator.server_host(property.as(String.class).orElse(null)));
				results.get(1).getResult().ifPresent(property -> configuration_configurator.server_port(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(2).getResult().ifPresent(property -> configuration_configurator.server_event_loop_group_size(property.as(Integer.class).orElse(null)));
				results.get(3).getResult().ifPresent(property -> configuration_configurator.compression_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(4).getResult().ifPresent(property -> configuration_configurator.decompression_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(5).getResult().ifPresent(property -> configuration_configurator.compression_contentSizeThreshold(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(6).getResult().ifPresent(property -> configuration_configurator.compression_brotli_quality(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(7).getResult().ifPresent(property -> configuration_configurator.compression_brotli_window(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(8).getResult().ifPresent(property -> configuration_configurator.compression_brotli_mode(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(9).getResult().ifPresent(property -> configuration_configurator.compression_deflate_compressionLevel(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(10).getResult().ifPresent(property -> configuration_configurator.compression_deflate_windowBits(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(11).getResult().ifPresent(property -> configuration_configurator.compression_deflate_memLevel(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(12).getResult().ifPresent(property -> configuration_configurator.compression_gzip_compressionLevel(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(13).getResult().ifPresent(property -> configuration_configurator.compression_gzip_windowBits(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(14).getResult().ifPresent(property -> configuration_configurator.compression_gzip_memLevel(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(15).getResult().ifPresent(property -> configuration_configurator.compression_zstd_blockSize(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(16).getResult().ifPresent(property -> configuration_configurator.compression_zstd_compressionLevel(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(17).getResult().ifPresent(property -> configuration_configurator.compression_zstd_maxEncodeSize(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(18).getResult().ifPresent(property -> configuration_configurator.key_store(property.as(URI.class).orElse(null)));
				results.get(19).getResult().ifPresent(property -> configuration_configurator.key_store_type(property.as(String.class).orElse(null)));
				results.get(20).getResult().ifPresent(property -> configuration_configurator.key_store_password(property.as(String.class).orElse(null)));
				results.get(21).getResult().ifPresent(property -> configuration_configurator.tls_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(22).getResult().ifPresent(property -> configuration_configurator.tls_handshake_timeout(property.asLong().orElseGet(() -> (new long[1])[0])));
				results.get(23).getResult().ifPresent(property -> configuration_configurator.tls_ciphers_includes(property.asArrayOf(String.class).orElse(null)));
				results.get(24).getResult().ifPresent(property -> configuration_configurator.tls_ciphers_excludes(property.asArrayOf(String.class).orElse(null)));
				results.get(25).getResult().ifPresent(property -> configuration_configurator.h2c_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(26).getResult().ifPresent(property -> configuration_configurator.h2_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(27).getResult().ifPresent(property -> configuration_configurator.http2_header_table_size(property.as(Long.class).orElse(null)));
				results.get(28).getResult().ifPresent(property -> configuration_configurator.http2_max_concurrent_streams(property.as(Integer.class).orElse(null)));
				results.get(29).getResult().ifPresent(property -> configuration_configurator.http2_initial_window_size(property.as(Integer.class).orElse(null)));
				results.get(30).getResult().ifPresent(property -> configuration_configurator.http2_max_frame_size(property.as(Integer.class).orElse(null)));
				results.get(31).getResult().ifPresent(property -> configuration_configurator.http2_max_header_list_size(property.as(Integer.class).orElse(null)));
				results.get(32).getResult().ifPresent(property -> configuration_configurator.ws_handshake_timeout(property.asLong().orElseGet(() -> (new long[1])[0])));
				results.get(33).getResult().ifPresent(property -> configuration_configurator.ws_close_timeout(property.asLong().orElseGet(() -> (new long[1])[0])));
				results.get(34).getResult().ifPresent(property -> configuration_configurator.ws_max_frame_size(property.as(Integer.class).orElse(null)));
				results.get(35).getResult().ifPresent(property -> configuration_configurator.ws_allow_mask_mismatch(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(36).getResult().ifPresent(property -> configuration_configurator.ws_frame_compression_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(37).getResult().ifPresent(property -> configuration_configurator.ws_frame_compression_level(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(38).getResult().ifPresent(property -> configuration_configurator.ws_message_compression_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(39).getResult().ifPresent(property -> configuration_configurator.ws_message_compression_level(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(40).getResult().ifPresent(property -> configuration_configurator.ws_message_allow_server_window_size(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(41).getResult().ifPresent(property -> configuration_configurator.ws_message_prefered_client_window_size(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(42).getResult().ifPresent(property -> configuration_configurator.ws_message_allow_server_no_context(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(43).getResult().ifPresent(property -> configuration_configurator.ws_message_preferred_client_no_context(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(44).getResult().ifPresent(property -> configuration_configurator.ws_close_on_outbound_complete(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(45).getResult().ifPresent(property -> configuration_configurator.ws_inbound_close_frame_timeout(property.asLong().orElseGet(() -> (new long[1])[0])));
			},
			HttpServerConfigurationLoader::load,
			HttpServerConfigurationLoader.Configuration::new
		);
	}

	public static HttpServerConfiguration load(Consumer<HttpServerConfigurationLoader.Configurator> configurer) {
		if(configurer == null) {
			return new HttpServerConfigurationLoader.Configuration();
		}
		HttpServerConfigurationLoader.Configurator configurator = new HttpServerConfigurationLoader.Configurator();
		configurer.accept(configurator);
		return new HttpServerConfigurationLoader.Configuration(configurator.server_host, configurator.server_port, configurator.server_event_loop_group_size, configurator.compression_enabled, configurator.decompression_enabled, configurator.compression_contentSizeThreshold, configurator.compression_brotli_quality, configurator.compression_brotli_window, configurator.compression_brotli_mode, configurator.compression_deflate_compressionLevel, configurator.compression_deflate_windowBits, configurator.compression_deflate_memLevel, configurator.compression_gzip_compressionLevel, configurator.compression_gzip_windowBits, configurator.compression_gzip_memLevel, configurator.compression_zstd_blockSize, configurator.compression_zstd_compressionLevel, configurator.compression_zstd_maxEncodeSize, configurator.key_store, configurator.key_store_type, configurator.key_store_password, configurator.tls_enabled, configurator.tls_handshake_timeout, configurator.tls_ciphers_includes, configurator.tls_ciphers_excludes, configurator.h2c_enabled, configurator.h2_enabled, configurator.http2_header_table_size, configurator.http2_max_concurrent_streams, configurator.http2_initial_window_size, configurator.http2_max_frame_size, configurator.http2_max_header_list_size, configurator.ws_handshake_timeout, configurator.ws_close_timeout, configurator.ws_max_frame_size, configurator.ws_allow_mask_mismatch, configurator.ws_frame_compression_enabled, configurator.ws_frame_compression_level, configurator.ws_message_compression_enabled, configurator.ws_message_compression_level, configurator.ws_message_allow_server_window_size, configurator.ws_message_prefered_client_window_size, configurator.ws_message_allow_server_no_context, configurator.ws_message_preferred_client_no_context, configurator.ws_close_on_outbound_complete, configurator.ws_inbound_close_frame_timeout);
	}

	public static HttpServerConfiguration load(HttpServerConfiguration configuration, Consumer<HttpServerConfigurationLoader.Configurator> configurer) {
		if(configurer == null) {
			return configuration;
		}
		Consumer<HttpServerConfigurationLoader.Configurator> rootConfigurer = configurator -> configurator
			.server_host(configuration.server_host())
			.server_port(configuration.server_port())
			.server_event_loop_group_size(configuration.server_event_loop_group_size())
			.compression_enabled(configuration.compression_enabled())
			.decompression_enabled(configuration.decompression_enabled())
			.compression_contentSizeThreshold(configuration.compression_contentSizeThreshold())
			.compression_brotli_quality(configuration.compression_brotli_quality())
			.compression_brotli_window(configuration.compression_brotli_window())
			.compression_brotli_mode(configuration.compression_brotli_mode())
			.compression_deflate_compressionLevel(configuration.compression_deflate_compressionLevel())
			.compression_deflate_windowBits(configuration.compression_deflate_windowBits())
			.compression_deflate_memLevel(configuration.compression_deflate_memLevel())
			.compression_gzip_compressionLevel(configuration.compression_gzip_compressionLevel())
			.compression_gzip_windowBits(configuration.compression_gzip_windowBits())
			.compression_gzip_memLevel(configuration.compression_gzip_memLevel())
			.compression_zstd_blockSize(configuration.compression_zstd_blockSize())
			.compression_zstd_compressionLevel(configuration.compression_zstd_compressionLevel())
			.compression_zstd_maxEncodeSize(configuration.compression_zstd_maxEncodeSize())
			.key_store(configuration.key_store())
			.key_store_type(configuration.key_store_type())
			.key_store_password(configuration.key_store_password())
			.tls_enabled(configuration.tls_enabled())
			.tls_handshake_timeout(configuration.tls_handshake_timeout())
			.tls_ciphers_includes(configuration.tls_ciphers_includes())
			.tls_ciphers_excludes(configuration.tls_ciphers_excludes())
			.h2c_enabled(configuration.h2c_enabled())
			.h2_enabled(configuration.h2_enabled())
			.http2_header_table_size(configuration.http2_header_table_size())
			.http2_max_concurrent_streams(configuration.http2_max_concurrent_streams())
			.http2_initial_window_size(configuration.http2_initial_window_size())
			.http2_max_frame_size(configuration.http2_max_frame_size())
			.http2_max_header_list_size(configuration.http2_max_header_list_size())
			.ws_handshake_timeout(configuration.ws_handshake_timeout())
			.ws_close_timeout(configuration.ws_close_timeout())
			.ws_max_frame_size(configuration.ws_max_frame_size())
			.ws_allow_mask_mismatch(configuration.ws_allow_mask_mismatch())
			.ws_frame_compression_enabled(configuration.ws_frame_compression_enabled())
			.ws_frame_compression_level(configuration.ws_frame_compression_level())
			.ws_message_compression_enabled(configuration.ws_message_compression_enabled())
			.ws_message_compression_level(configuration.ws_message_compression_level())
			.ws_message_allow_server_window_size(configuration.ws_message_allow_server_window_size())
			.ws_message_prefered_client_window_size(configuration.ws_message_prefered_client_window_size())
			.ws_message_allow_server_no_context(configuration.ws_message_allow_server_no_context())
			.ws_message_preferred_client_no_context(configuration.ws_message_preferred_client_no_context())
			.ws_close_on_outbound_complete(configuration.ws_close_on_outbound_complete())
			.ws_inbound_close_frame_timeout(configuration.ws_inbound_close_frame_timeout());

		HttpServerConfigurationLoader.Configurator configurator = new HttpServerConfigurationLoader.Configurator();
		rootConfigurer.andThen(configurer).accept(configurator);
		return new HttpServerConfigurationLoader.Configuration(configurator.server_host, configurator.server_port, configurator.server_event_loop_group_size, configurator.compression_enabled, configurator.decompression_enabled, configurator.compression_contentSizeThreshold, configurator.compression_brotli_quality, configurator.compression_brotli_window, configurator.compression_brotli_mode, configurator.compression_deflate_compressionLevel, configurator.compression_deflate_windowBits, configurator.compression_deflate_memLevel, configurator.compression_gzip_compressionLevel, configurator.compression_gzip_windowBits, configurator.compression_gzip_memLevel, configurator.compression_zstd_blockSize, configurator.compression_zstd_compressionLevel, configurator.compression_zstd_maxEncodeSize, configurator.key_store, configurator.key_store_type, configurator.key_store_password, configurator.tls_enabled, configurator.tls_handshake_timeout, configurator.tls_ciphers_includes, configurator.tls_ciphers_excludes, configurator.h2c_enabled, configurator.h2_enabled, configurator.http2_header_table_size, configurator.http2_max_concurrent_streams, configurator.http2_initial_window_size, configurator.http2_max_frame_size, configurator.http2_max_header_list_size, configurator.ws_handshake_timeout, configurator.ws_close_timeout, configurator.ws_max_frame_size, configurator.ws_allow_mask_mismatch, configurator.ws_frame_compression_enabled, configurator.ws_frame_compression_level, configurator.ws_message_compression_enabled, configurator.ws_message_compression_level, configurator.ws_message_allow_server_window_size, configurator.ws_message_prefered_client_window_size, configurator.ws_message_allow_server_no_context, configurator.ws_message_preferred_client_no_context, configurator.ws_close_on_outbound_complete, configurator.ws_inbound_close_frame_timeout);
	}

	private static final class Configuration implements HttpServerConfiguration {

		private String server_host = HttpServerConfiguration.super.server_host();
		private int server_port = HttpServerConfiguration.super.server_port();
		private Integer server_event_loop_group_size;
		private boolean compression_enabled = HttpServerConfiguration.super.compression_enabled();
		private boolean decompression_enabled = HttpServerConfiguration.super.decompression_enabled();
		private int compression_contentSizeThreshold = HttpServerConfiguration.super.compression_contentSizeThreshold();
		private int compression_brotli_quality = HttpServerConfiguration.super.compression_brotli_quality();
		private int compression_brotli_window = HttpServerConfiguration.super.compression_brotli_window();
		private int compression_brotli_mode = HttpServerConfiguration.super.compression_brotli_mode();
		private int compression_deflate_compressionLevel = HttpServerConfiguration.super.compression_deflate_compressionLevel();
		private int compression_deflate_windowBits = HttpServerConfiguration.super.compression_deflate_windowBits();
		private int compression_deflate_memLevel = HttpServerConfiguration.super.compression_deflate_memLevel();
		private int compression_gzip_compressionLevel = HttpServerConfiguration.super.compression_gzip_compressionLevel();
		private int compression_gzip_windowBits = HttpServerConfiguration.super.compression_gzip_windowBits();
		private int compression_gzip_memLevel = HttpServerConfiguration.super.compression_gzip_memLevel();
		private int compression_zstd_blockSize = HttpServerConfiguration.super.compression_zstd_blockSize();
		private int compression_zstd_compressionLevel = HttpServerConfiguration.super.compression_zstd_compressionLevel();
		private int compression_zstd_maxEncodeSize = HttpServerConfiguration.super.compression_zstd_maxEncodeSize();
		private URI key_store;
		private String key_store_type = HttpServerConfiguration.super.key_store_type();
		private String key_store_password;
		private boolean tls_enabled = HttpServerConfiguration.super.tls_enabled();
		private long tls_handshake_timeout = HttpServerConfiguration.super.tls_handshake_timeout();
		private String[] tls_ciphers_includes;
		private String[] tls_ciphers_excludes;
		private boolean h2c_enabled = HttpServerConfiguration.super.h2c_enabled();
		private boolean h2_enabled = HttpServerConfiguration.super.h2_enabled();
		private Long http2_header_table_size = HttpServerConfiguration.super.http2_header_table_size();
		private Integer http2_max_concurrent_streams = HttpServerConfiguration.super.http2_max_concurrent_streams();
		private Integer http2_initial_window_size = HttpServerConfiguration.super.http2_initial_window_size();
		private Integer http2_max_frame_size = HttpServerConfiguration.super.http2_max_frame_size();
		private Integer http2_max_header_list_size = HttpServerConfiguration.super.http2_max_header_list_size();
		private long ws_handshake_timeout = HttpServerConfiguration.super.ws_handshake_timeout();
		private long ws_close_timeout = HttpServerConfiguration.super.ws_close_timeout();
		private Integer ws_max_frame_size = HttpServerConfiguration.super.ws_max_frame_size();
		private boolean ws_allow_mask_mismatch = HttpServerConfiguration.super.ws_allow_mask_mismatch();
		private boolean ws_frame_compression_enabled = HttpServerConfiguration.super.ws_frame_compression_enabled();
		private int ws_frame_compression_level = HttpServerConfiguration.super.ws_frame_compression_level();
		private boolean ws_message_compression_enabled = HttpServerConfiguration.super.ws_message_compression_enabled();
		private int ws_message_compression_level = HttpServerConfiguration.super.ws_message_compression_level();
		private boolean ws_message_allow_server_window_size = HttpServerConfiguration.super.ws_message_allow_server_window_size();
		private int ws_message_prefered_client_window_size = HttpServerConfiguration.super.ws_message_prefered_client_window_size();
		private boolean ws_message_allow_server_no_context = HttpServerConfiguration.super.ws_message_allow_server_no_context();
		private boolean ws_message_preferred_client_no_context = HttpServerConfiguration.super.ws_message_preferred_client_no_context();
		private boolean ws_close_on_outbound_complete = HttpServerConfiguration.super.ws_close_on_outbound_complete();
		private long ws_inbound_close_frame_timeout = HttpServerConfiguration.super.ws_inbound_close_frame_timeout();

		private Configuration() {}

		public Configuration(Supplier<String> server_host, Supplier<Integer> server_port, Supplier<Integer> server_event_loop_group_size, Supplier<Boolean> compression_enabled, Supplier<Boolean> decompression_enabled, Supplier<Integer> compression_contentSizeThreshold, Supplier<Integer> compression_brotli_quality, Supplier<Integer> compression_brotli_window, Supplier<Integer> compression_brotli_mode, Supplier<Integer> compression_deflate_compressionLevel, Supplier<Integer> compression_deflate_windowBits, Supplier<Integer> compression_deflate_memLevel, Supplier<Integer> compression_gzip_compressionLevel, Supplier<Integer> compression_gzip_windowBits, Supplier<Integer> compression_gzip_memLevel, Supplier<Integer> compression_zstd_blockSize, Supplier<Integer> compression_zstd_compressionLevel, Supplier<Integer> compression_zstd_maxEncodeSize, Supplier<URI> key_store, Supplier<String> key_store_type, Supplier<String> key_store_password, Supplier<Boolean> tls_enabled, Supplier<Long> tls_handshake_timeout, Supplier<String[]> tls_ciphers_includes, Supplier<String[]> tls_ciphers_excludes, Supplier<Boolean> h2c_enabled, Supplier<Boolean> h2_enabled, Supplier<Long> http2_header_table_size, Supplier<Integer> http2_max_concurrent_streams, Supplier<Integer> http2_initial_window_size, Supplier<Integer> http2_max_frame_size, Supplier<Integer> http2_max_header_list_size, Supplier<Long> ws_handshake_timeout, Supplier<Long> ws_close_timeout, Supplier<Integer> ws_max_frame_size, Supplier<Boolean> ws_allow_mask_mismatch, Supplier<Boolean> ws_frame_compression_enabled, Supplier<Integer> ws_frame_compression_level, Supplier<Boolean> ws_message_compression_enabled, Supplier<Integer> ws_message_compression_level, Supplier<Boolean> ws_message_allow_server_window_size, Supplier<Integer> ws_message_prefered_client_window_size, Supplier<Boolean> ws_message_allow_server_no_context, Supplier<Boolean> ws_message_preferred_client_no_context, Supplier<Boolean> ws_close_on_outbound_complete, Supplier<Long> ws_inbound_close_frame_timeout) {
			Optional.ofNullable(server_host).ifPresent(s -> this.server_host = s.get());
			Optional.ofNullable(server_port).ifPresent(s -> this.server_port = s.get());
			Optional.ofNullable(server_event_loop_group_size).ifPresent(s -> this.server_event_loop_group_size = s.get());
			Optional.ofNullable(compression_enabled).ifPresent(s -> this.compression_enabled = s.get());
			Optional.ofNullable(decompression_enabled).ifPresent(s -> this.decompression_enabled = s.get());
			Optional.ofNullable(compression_contentSizeThreshold).ifPresent(s -> this.compression_contentSizeThreshold = s.get());
			Optional.ofNullable(compression_brotli_quality).ifPresent(s -> this.compression_brotli_quality = s.get());
			Optional.ofNullable(compression_brotli_window).ifPresent(s -> this.compression_brotli_window = s.get());
			Optional.ofNullable(compression_brotli_mode).ifPresent(s -> this.compression_brotli_mode = s.get());
			Optional.ofNullable(compression_deflate_compressionLevel).ifPresent(s -> this.compression_deflate_compressionLevel = s.get());
			Optional.ofNullable(compression_deflate_windowBits).ifPresent(s -> this.compression_deflate_windowBits = s.get());
			Optional.ofNullable(compression_deflate_memLevel).ifPresent(s -> this.compression_deflate_memLevel = s.get());
			Optional.ofNullable(compression_gzip_compressionLevel).ifPresent(s -> this.compression_gzip_compressionLevel = s.get());
			Optional.ofNullable(compression_gzip_windowBits).ifPresent(s -> this.compression_gzip_windowBits = s.get());
			Optional.ofNullable(compression_gzip_memLevel).ifPresent(s -> this.compression_gzip_memLevel = s.get());
			Optional.ofNullable(compression_zstd_blockSize).ifPresent(s -> this.compression_zstd_blockSize = s.get());
			Optional.ofNullable(compression_zstd_compressionLevel).ifPresent(s -> this.compression_zstd_compressionLevel = s.get());
			Optional.ofNullable(compression_zstd_maxEncodeSize).ifPresent(s -> this.compression_zstd_maxEncodeSize = s.get());
			Optional.ofNullable(key_store).ifPresent(s -> this.key_store = s.get());
			Optional.ofNullable(key_store_type).ifPresent(s -> this.key_store_type = s.get());
			Optional.ofNullable(key_store_password).ifPresent(s -> this.key_store_password = s.get());
			Optional.ofNullable(tls_enabled).ifPresent(s -> this.tls_enabled = s.get());
			Optional.ofNullable(tls_handshake_timeout).ifPresent(s -> this.tls_handshake_timeout = s.get());
			Optional.ofNullable(tls_ciphers_includes).ifPresent(s -> this.tls_ciphers_includes = s.get());
			Optional.ofNullable(tls_ciphers_excludes).ifPresent(s -> this.tls_ciphers_excludes = s.get());
			Optional.ofNullable(h2c_enabled).ifPresent(s -> this.h2c_enabled = s.get());
			Optional.ofNullable(h2_enabled).ifPresent(s -> this.h2_enabled = s.get());
			Optional.ofNullable(http2_header_table_size).ifPresent(s -> this.http2_header_table_size = s.get());
			Optional.ofNullable(http2_max_concurrent_streams).ifPresent(s -> this.http2_max_concurrent_streams = s.get());
			Optional.ofNullable(http2_initial_window_size).ifPresent(s -> this.http2_initial_window_size = s.get());
			Optional.ofNullable(http2_max_frame_size).ifPresent(s -> this.http2_max_frame_size = s.get());
			Optional.ofNullable(http2_max_header_list_size).ifPresent(s -> this.http2_max_header_list_size = s.get());
			Optional.ofNullable(ws_handshake_timeout).ifPresent(s -> this.ws_handshake_timeout = s.get());
			Optional.ofNullable(ws_close_timeout).ifPresent(s -> this.ws_close_timeout = s.get());
			Optional.ofNullable(ws_max_frame_size).ifPresent(s -> this.ws_max_frame_size = s.get());
			Optional.ofNullable(ws_allow_mask_mismatch).ifPresent(s -> this.ws_allow_mask_mismatch = s.get());
			Optional.ofNullable(ws_frame_compression_enabled).ifPresent(s -> this.ws_frame_compression_enabled = s.get());
			Optional.ofNullable(ws_frame_compression_level).ifPresent(s -> this.ws_frame_compression_level = s.get());
			Optional.ofNullable(ws_message_compression_enabled).ifPresent(s -> this.ws_message_compression_enabled = s.get());
			Optional.ofNullable(ws_message_compression_level).ifPresent(s -> this.ws_message_compression_level = s.get());
			Optional.ofNullable(ws_message_allow_server_window_size).ifPresent(s -> this.ws_message_allow_server_window_size = s.get());
			Optional.ofNullable(ws_message_prefered_client_window_size).ifPresent(s -> this.ws_message_prefered_client_window_size = s.get());
			Optional.ofNullable(ws_message_allow_server_no_context).ifPresent(s -> this.ws_message_allow_server_no_context = s.get());
			Optional.ofNullable(ws_message_preferred_client_no_context).ifPresent(s -> this.ws_message_preferred_client_no_context = s.get());
			Optional.ofNullable(ws_close_on_outbound_complete).ifPresent(s -> this.ws_close_on_outbound_complete = s.get());
			Optional.ofNullable(ws_inbound_close_frame_timeout).ifPresent(s -> this.ws_inbound_close_frame_timeout = s.get());
		}

		public String server_host() {
			 return this.server_host;
		}

		public int server_port() {
			 return this.server_port;
		}

		public Integer server_event_loop_group_size() {
			 return this.server_event_loop_group_size;
		}

		public boolean compression_enabled() {
			 return this.compression_enabled;
		}

		public boolean decompression_enabled() {
			 return this.decompression_enabled;
		}

		public int compression_contentSizeThreshold() {
			 return this.compression_contentSizeThreshold;
		}

		public int compression_brotli_quality() {
			 return this.compression_brotli_quality;
		}

		public int compression_brotli_window() {
			 return this.compression_brotli_window;
		}

		public int compression_brotli_mode() {
			 return this.compression_brotli_mode;
		}

		public int compression_deflate_compressionLevel() {
			 return this.compression_deflate_compressionLevel;
		}

		public int compression_deflate_windowBits() {
			 return this.compression_deflate_windowBits;
		}

		public int compression_deflate_memLevel() {
			 return this.compression_deflate_memLevel;
		}

		public int compression_gzip_compressionLevel() {
			 return this.compression_gzip_compressionLevel;
		}

		public int compression_gzip_windowBits() {
			 return this.compression_gzip_windowBits;
		}

		public int compression_gzip_memLevel() {
			 return this.compression_gzip_memLevel;
		}

		public int compression_zstd_blockSize() {
			 return this.compression_zstd_blockSize;
		}

		public int compression_zstd_compressionLevel() {
			 return this.compression_zstd_compressionLevel;
		}

		public int compression_zstd_maxEncodeSize() {
			 return this.compression_zstd_maxEncodeSize;
		}

		public URI key_store() {
			 return this.key_store;
		}

		public String key_store_type() {
			 return this.key_store_type;
		}

		public String key_store_password() {
			 return this.key_store_password;
		}

		public boolean tls_enabled() {
			 return this.tls_enabled;
		}

		public long tls_handshake_timeout() {
			 return this.tls_handshake_timeout;
		}

		public String[] tls_ciphers_includes() {
			 return this.tls_ciphers_includes;
		}

		public String[] tls_ciphers_excludes() {
			 return this.tls_ciphers_excludes;
		}

		public boolean h2c_enabled() {
			 return this.h2c_enabled;
		}

		public boolean h2_enabled() {
			 return this.h2_enabled;
		}

		public Long http2_header_table_size() {
			 return this.http2_header_table_size;
		}

		public Integer http2_max_concurrent_streams() {
			 return this.http2_max_concurrent_streams;
		}

		public Integer http2_initial_window_size() {
			 return this.http2_initial_window_size;
		}

		public Integer http2_max_frame_size() {
			 return this.http2_max_frame_size;
		}

		public Integer http2_max_header_list_size() {
			 return this.http2_max_header_list_size;
		}

		public long ws_handshake_timeout() {
			 return this.ws_handshake_timeout;
		}

		public long ws_close_timeout() {
			 return this.ws_close_timeout;
		}

		public Integer ws_max_frame_size() {
			 return this.ws_max_frame_size;
		}

		public boolean ws_allow_mask_mismatch() {
			 return this.ws_allow_mask_mismatch;
		}

		public boolean ws_frame_compression_enabled() {
			 return this.ws_frame_compression_enabled;
		}

		public int ws_frame_compression_level() {
			 return this.ws_frame_compression_level;
		}

		public boolean ws_message_compression_enabled() {
			 return this.ws_message_compression_enabled;
		}

		public int ws_message_compression_level() {
			 return this.ws_message_compression_level;
		}

		public boolean ws_message_allow_server_window_size() {
			 return this.ws_message_allow_server_window_size;
		}

		public int ws_message_prefered_client_window_size() {
			 return this.ws_message_prefered_client_window_size;
		}

		public boolean ws_message_allow_server_no_context() {
			 return this.ws_message_allow_server_no_context;
		}

		public boolean ws_message_preferred_client_no_context() {
			 return this.ws_message_preferred_client_no_context;
		}

		public boolean ws_close_on_outbound_complete() {
			 return this.ws_close_on_outbound_complete;
		}

		public long ws_inbound_close_frame_timeout() {
			 return this.ws_inbound_close_frame_timeout;
		}
	}

	public static final class Configurator {

		private Supplier<String> server_host;
		private Supplier<Integer> server_port;
		private Supplier<Integer> server_event_loop_group_size;
		private Supplier<Boolean> compression_enabled;
		private Supplier<Boolean> decompression_enabled;
		private Supplier<Integer> compression_contentSizeThreshold;
		private Supplier<Integer> compression_brotli_quality;
		private Supplier<Integer> compression_brotli_window;
		private Supplier<Integer> compression_brotli_mode;
		private Supplier<Integer> compression_deflate_compressionLevel;
		private Supplier<Integer> compression_deflate_windowBits;
		private Supplier<Integer> compression_deflate_memLevel;
		private Supplier<Integer> compression_gzip_compressionLevel;
		private Supplier<Integer> compression_gzip_windowBits;
		private Supplier<Integer> compression_gzip_memLevel;
		private Supplier<Integer> compression_zstd_blockSize;
		private Supplier<Integer> compression_zstd_compressionLevel;
		private Supplier<Integer> compression_zstd_maxEncodeSize;
		private Supplier<URI> key_store;
		private Supplier<String> key_store_type;
		private Supplier<String> key_store_password;
		private Supplier<Boolean> tls_enabled;
		private Supplier<Long> tls_handshake_timeout;
		private Supplier<String[]> tls_ciphers_includes;
		private Supplier<String[]> tls_ciphers_excludes;
		private Supplier<Boolean> h2c_enabled;
		private Supplier<Boolean> h2_enabled;
		private Supplier<Long> http2_header_table_size;
		private Supplier<Integer> http2_max_concurrent_streams;
		private Supplier<Integer> http2_initial_window_size;
		private Supplier<Integer> http2_max_frame_size;
		private Supplier<Integer> http2_max_header_list_size;
		private Supplier<Long> ws_handshake_timeout;
		private Supplier<Long> ws_close_timeout;
		private Supplier<Integer> ws_max_frame_size;
		private Supplier<Boolean> ws_allow_mask_mismatch;
		private Supplier<Boolean> ws_frame_compression_enabled;
		private Supplier<Integer> ws_frame_compression_level;
		private Supplier<Boolean> ws_message_compression_enabled;
		private Supplier<Integer> ws_message_compression_level;
		private Supplier<Boolean> ws_message_allow_server_window_size;
		private Supplier<Integer> ws_message_prefered_client_window_size;
		private Supplier<Boolean> ws_message_allow_server_no_context;
		private Supplier<Boolean> ws_message_preferred_client_no_context;
		private Supplier<Boolean> ws_close_on_outbound_complete;
		private Supplier<Long> ws_inbound_close_frame_timeout;

		private Configurator() {}

		public Configurator server_host(String server_host) {
			this.server_host = () -> server_host;
			return this;
		}

		public Configurator server_port(int server_port) {
			this.server_port = () -> server_port;
			return this;
		}

		public Configurator server_event_loop_group_size(Integer server_event_loop_group_size) {
			this.server_event_loop_group_size = () -> server_event_loop_group_size;
			return this;
		}

		public Configurator compression_enabled(boolean compression_enabled) {
			this.compression_enabled = () -> compression_enabled;
			return this;
		}

		public Configurator decompression_enabled(boolean decompression_enabled) {
			this.decompression_enabled = () -> decompression_enabled;
			return this;
		}

		public Configurator compression_contentSizeThreshold(int compression_contentSizeThreshold) {
			this.compression_contentSizeThreshold = () -> compression_contentSizeThreshold;
			return this;
		}

		public Configurator compression_brotli_quality(int compression_brotli_quality) {
			this.compression_brotli_quality = () -> compression_brotli_quality;
			return this;
		}

		public Configurator compression_brotli_window(int compression_brotli_window) {
			this.compression_brotli_window = () -> compression_brotli_window;
			return this;
		}

		public Configurator compression_brotli_mode(int compression_brotli_mode) {
			this.compression_brotli_mode = () -> compression_brotli_mode;
			return this;
		}

		public Configurator compression_deflate_compressionLevel(int compression_deflate_compressionLevel) {
			this.compression_deflate_compressionLevel = () -> compression_deflate_compressionLevel;
			return this;
		}

		public Configurator compression_deflate_windowBits(int compression_deflate_windowBits) {
			this.compression_deflate_windowBits = () -> compression_deflate_windowBits;
			return this;
		}

		public Configurator compression_deflate_memLevel(int compression_deflate_memLevel) {
			this.compression_deflate_memLevel = () -> compression_deflate_memLevel;
			return this;
		}

		public Configurator compression_gzip_compressionLevel(int compression_gzip_compressionLevel) {
			this.compression_gzip_compressionLevel = () -> compression_gzip_compressionLevel;
			return this;
		}

		public Configurator compression_gzip_windowBits(int compression_gzip_windowBits) {
			this.compression_gzip_windowBits = () -> compression_gzip_windowBits;
			return this;
		}

		public Configurator compression_gzip_memLevel(int compression_gzip_memLevel) {
			this.compression_gzip_memLevel = () -> compression_gzip_memLevel;
			return this;
		}

		public Configurator compression_zstd_blockSize(int compression_zstd_blockSize) {
			this.compression_zstd_blockSize = () -> compression_zstd_blockSize;
			return this;
		}

		public Configurator compression_zstd_compressionLevel(int compression_zstd_compressionLevel) {
			this.compression_zstd_compressionLevel = () -> compression_zstd_compressionLevel;
			return this;
		}

		public Configurator compression_zstd_maxEncodeSize(int compression_zstd_maxEncodeSize) {
			this.compression_zstd_maxEncodeSize = () -> compression_zstd_maxEncodeSize;
			return this;
		}

		public Configurator key_store(URI key_store) {
			this.key_store = () -> key_store;
			return this;
		}

		public Configurator key_store_type(String key_store_type) {
			this.key_store_type = () -> key_store_type;
			return this;
		}

		public Configurator key_store_password(String key_store_password) {
			this.key_store_password = () -> key_store_password;
			return this;
		}

		public Configurator tls_enabled(boolean tls_enabled) {
			this.tls_enabled = () -> tls_enabled;
			return this;
		}

		public Configurator tls_handshake_timeout(long tls_handshake_timeout) {
			this.tls_handshake_timeout = () -> tls_handshake_timeout;
			return this;
		}

		public Configurator tls_ciphers_includes(String[] tls_ciphers_includes) {
			this.tls_ciphers_includes = () -> tls_ciphers_includes;
			return this;
		}

		public Configurator tls_ciphers_excludes(String[] tls_ciphers_excludes) {
			this.tls_ciphers_excludes = () -> tls_ciphers_excludes;
			return this;
		}

		public Configurator h2c_enabled(boolean h2c_enabled) {
			this.h2c_enabled = () -> h2c_enabled;
			return this;
		}

		public Configurator h2_enabled(boolean h2_enabled) {
			this.h2_enabled = () -> h2_enabled;
			return this;
		}

		public Configurator http2_header_table_size(Long http2_header_table_size) {
			this.http2_header_table_size = () -> http2_header_table_size;
			return this;
		}

		public Configurator http2_max_concurrent_streams(Integer http2_max_concurrent_streams) {
			this.http2_max_concurrent_streams = () -> http2_max_concurrent_streams;
			return this;
		}

		public Configurator http2_initial_window_size(Integer http2_initial_window_size) {
			this.http2_initial_window_size = () -> http2_initial_window_size;
			return this;
		}

		public Configurator http2_max_frame_size(Integer http2_max_frame_size) {
			this.http2_max_frame_size = () -> http2_max_frame_size;
			return this;
		}

		public Configurator http2_max_header_list_size(Integer http2_max_header_list_size) {
			this.http2_max_header_list_size = () -> http2_max_header_list_size;
			return this;
		}

		public Configurator ws_handshake_timeout(long ws_handshake_timeout) {
			this.ws_handshake_timeout = () -> ws_handshake_timeout;
			return this;
		}

		public Configurator ws_close_timeout(long ws_close_timeout) {
			this.ws_close_timeout = () -> ws_close_timeout;
			return this;
		}

		public Configurator ws_max_frame_size(Integer ws_max_frame_size) {
			this.ws_max_frame_size = () -> ws_max_frame_size;
			return this;
		}

		public Configurator ws_allow_mask_mismatch(boolean ws_allow_mask_mismatch) {
			this.ws_allow_mask_mismatch = () -> ws_allow_mask_mismatch;
			return this;
		}

		public Configurator ws_frame_compression_enabled(boolean ws_frame_compression_enabled) {
			this.ws_frame_compression_enabled = () -> ws_frame_compression_enabled;
			return this;
		}

		public Configurator ws_frame_compression_level(int ws_frame_compression_level) {
			this.ws_frame_compression_level = () -> ws_frame_compression_level;
			return this;
		}

		public Configurator ws_message_compression_enabled(boolean ws_message_compression_enabled) {
			this.ws_message_compression_enabled = () -> ws_message_compression_enabled;
			return this;
		}

		public Configurator ws_message_compression_level(int ws_message_compression_level) {
			this.ws_message_compression_level = () -> ws_message_compression_level;
			return this;
		}

		public Configurator ws_message_allow_server_window_size(boolean ws_message_allow_server_window_size) {
			this.ws_message_allow_server_window_size = () -> ws_message_allow_server_window_size;
			return this;
		}

		public Configurator ws_message_prefered_client_window_size(int ws_message_prefered_client_window_size) {
			this.ws_message_prefered_client_window_size = () -> ws_message_prefered_client_window_size;
			return this;
		}

		public Configurator ws_message_allow_server_no_context(boolean ws_message_allow_server_no_context) {
			this.ws_message_allow_server_no_context = () -> ws_message_allow_server_no_context;
			return this;
		}

		public Configurator ws_message_preferred_client_no_context(boolean ws_message_preferred_client_no_context) {
			this.ws_message_preferred_client_no_context = () -> ws_message_preferred_client_no_context;
			return this;
		}

		public Configurator ws_close_on_outbound_complete(boolean ws_close_on_outbound_complete) {
			this.ws_close_on_outbound_complete = () -> ws_close_on_outbound_complete;
			return this;
		}

		public Configurator ws_inbound_close_frame_timeout(long ws_inbound_close_frame_timeout) {
			this.ws_inbound_close_frame_timeout = () -> ws_inbound_close_frame_timeout;
			return this;
		}
	}

	@io.inverno.core.annotation.Bean(name = "configuration")
	@Wrapper
	@Overridable
	public static final class Bean extends ConfigurationLoaderSupport.ConfigurationBeanSupport<HttpServerConfiguration, HttpServerConfigurationLoader.Configurator, HttpServerConfigurationLoader> implements Supplier<HttpServerConfiguration> {

		public Bean() {
			super(new HttpServerConfigurationLoader());
		}

		public void setConfigurationSource(ConfigurationSource<?, ?, ?> source) {
			this.loader.withSource(source);
		}

		public void setParameters(Parameter[] parameters) {
			this.loader.withParameters(parameters);
		}

		public void setConfigurer(Consumer<HttpServerConfigurationLoader.Configurator> configurer) {
			this.loader.withConfigurer(configurer);
		}
	}
}