/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.netty;

import io.inverno.mod.http.server.internal.netty.FlatHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;

public class FlatFullHttpResponse
extends FlatHttpResponse
implements FullHttpResponse {
    private HttpHeaders trailingHeaders;

    public FlatFullHttpResponse(HttpVersion version, HttpResponseStatus status, HttpHeaders headers, ByteBuf content, HttpHeaders trailingHeaders) {
        super(version, status, headers, content);
        this.trailingHeaders = trailingHeaders;
    }

    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public FlatFullHttpResponse copy() {
        return this.replace(this.content.copy());
    }

    @Override
    public FlatFullHttpResponse duplicate() {
        return this.replace(this.content.duplicate());
    }

    @Override
    public FlatFullHttpResponse retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    @Override
    public FlatFullHttpResponse replace(ByteBuf content) {
        return new FlatFullHttpResponse(this.version, this.status, this.headers.copy(), content, this.trailingHeaders);
    }

    @Override
    public FlatFullHttpResponse retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FlatFullHttpResponse retain() {
        super.retain();
        return this;
    }

    @Override
    public FlatFullHttpResponse touch() {
        super.touch();
        return this;
    }

    @Override
    public FlatFullHttpResponse touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public FlatFullHttpResponse setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public FlatFullHttpResponse setStatus(HttpResponseStatus status) {
        super.setStatus(status);
        return this;
    }
}

