/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.http.server.internal.HttpChannelConfigurer;
import io.inverno.mod.http.server.internal.http2.Http2ChannelHandler;
import io.inverno.mod.http.server.internal.netty.FlatFullHttpResponse;
import io.inverno.mod.http.server.internal.netty.LinkedHttpHeaders;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.List;

public class H2cUpgradeHandler
extends HttpObjectAggregator {
    private final HttpChannelConfigurer configurer;
    private boolean upgrading;

    public H2cUpgradeHandler(HttpChannelConfigurer configurer) {
        this(configurer, 0);
    }

    public H2cUpgradeHandler(HttpChannelConfigurer configurer, int maxContentLength) {
        super(maxContentLength);
        this.configurer = configurer;
    }

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        FullHttpRequest request;
        this.upgrading |= msg instanceof HttpRequest && ((HttpRequest)msg).headers().contains((CharSequence)"upgrade", Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, true);
        if (!this.upgrading) {
            ReferenceCountUtil.retain((Object)msg);
            out.add(msg);
            return;
        }
        if (msg instanceof FullHttpRequest) {
            request = (FullHttpRequest)msg;
            ReferenceCountUtil.retain((Object)msg);
            out.add(msg);
        } else {
            super.decode(ctx, (Object)msg, out);
            if (out.isEmpty()) {
                return;
            }
            this.upgrading = false;
            request = (FullHttpRequest)out.get(0);
        }
        ChannelPipeline pipeline = ctx.pipeline();
        HttpHeaders requestHeaders = request.headers();
        String connection = requestHeaders.get("connection");
        if (connection != null && connection.length() > 0) {
            List http2SettingsHeader;
            int connectionIndex = 0;
            int length = connection.length();
            String currentHeader = null;
            int currentHeaderIndex = 0;
            boolean skip = false;
            int headersFound = 0;
            while (connectionIndex < length) {
                char nextChar;
                if ((nextChar = Character.toLowerCase(connection.charAt(connectionIndex++))) == ',' || connectionIndex == length) {
                    if (!skip) {
                        ++headersFound;
                    }
                    currentHeader = null;
                    currentHeaderIndex = 0;
                    skip = false;
                    continue;
                }
                if (skip || nextChar == ' ') continue;
                if (currentHeader == null) {
                    if (nextChar == "upgrade".charAt(currentHeaderIndex)) {
                        currentHeader = "upgrade";
                    } else if (nextChar == "http2-settings".charAt(currentHeaderIndex)) {
                        currentHeader = "http2-settings";
                    } else {
                        skip = true;
                    }
                    ++currentHeaderIndex;
                    continue;
                }
                skip = nextChar != currentHeader.charAt(currentHeaderIndex++);
            }
            if (headersFound != 2) {
                this.sendBadRequest(request.protocolVersion(), ctx);
            }
            if ((http2SettingsHeader = requestHeaders.getAll("http2-settings")).isEmpty() || http2SettingsHeader.size() > 1) {
                this.sendBadRequest(request.protocolVersion(), ctx);
            }
            try {
                Http2Settings requestHttp2Settings = this.decodeSettingsHeader((CharSequence)http2SettingsHeader.get(0));
                ChannelFuture sendAcceptUpgradeComplete = this.sendAcceptUpgrade(request.protocolVersion(), ctx);
                Http2ChannelHandler http2ChannelHandler = this.configurer.upgradeToHttp2(pipeline);
                http2ChannelHandler.onHttpServerUpgrade(requestHttp2Settings);
                http2ChannelHandler.onSettingsRead(ctx, requestHttp2Settings);
                out.clear();
                DefaultHttp2Headers headers = new DefaultHttp2Headers();
                headers.method((CharSequence)request.method().name());
                headers.path((CharSequence)request.uri());
                headers.authority((CharSequence)request.headers().get("host"));
                headers.scheme((CharSequence)"http");
                request.headers().remove("http2-settings");
                request.headers().remove("host");
                request.headers().forEach(header -> headers.set((Object)((String)header.getKey()).toLowerCase(), (Object)((CharSequence)header.getValue())));
                boolean emptyRequest = request.content().readableBytes() == 0;
                DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)headers, emptyRequest);
                http2ChannelHandler.onHeadersRead(ctx, 1, headersFrame.headers(), headersFrame.padding(), headersFrame.isEndStream());
                if (!emptyRequest) {
                    DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(request.content(), true, 0);
                    http2ChannelHandler.onDataRead(ctx, 1, dataFrame.content(), dataFrame.padding(), dataFrame.isEndStream());
                    ctx.fireChannelRead((Object)new DefaultHttp2DataFrame(request.content(), true, 0));
                }
                sendAcceptUpgradeComplete.addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            }
            catch (IOException e) {
                this.sendBadRequest(request.protocolVersion(), ctx);
            }
        }
    }

    private ChannelFuture sendBadRequest(HttpVersion version, ChannelHandlerContext ctx) {
        LinkedHttpHeaders responseHeaders = new LinkedHttpHeaders();
        responseHeaders.add("connection", "close");
        FlatFullHttpResponse response = new FlatFullHttpResponse(version, HttpResponseStatus.BAD_REQUEST, responseHeaders, Unpooled.EMPTY_BUFFER, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        return ctx.writeAndFlush((Object)response);
    }

    private ChannelFuture sendAcceptUpgrade(HttpVersion version, ChannelHandlerContext ctx) {
        LinkedHttpHeaders responseHeaders = new LinkedHttpHeaders();
        responseHeaders.add("connection", "upgrade");
        responseHeaders.add("upgrade", Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
        FlatFullHttpResponse response = new FlatFullHttpResponse(version, HttpResponseStatus.SWITCHING_PROTOCOLS, responseHeaders, Unpooled.EMPTY_BUFFER, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        return ctx.writeAndFlush((Object)response);
    }

    private Http2Settings decodeSettingsHeader(CharSequence settingsHeader) throws IOException {
        Http2Settings http2Settings = new Http2Settings();
        byte[] settingsHeaderBytes = Base64.getUrlDecoder().decode(settingsHeader.toString());
        try (DataInputStream settingsDataStream = new DataInputStream(new ByteArrayInputStream(settingsHeaderBytes));){
            for (int readCount = 0; readCount < settingsHeaderBytes.length; readCount += 6) {
                int identifier = settingsDataStream.readUnsignedShort();
                long value = Integer.toUnsignedLong(settingsDataStream.readInt());
                http2Settings.put((char)identifier, Long.valueOf(value));
            }
            Http2Settings http2Settings2 = http2Settings;
            return http2Settings2;
        }
    }
}

