/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.internal.http1x.Http1xExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xRequest;
import io.inverno.mod.http.server.internal.http1x.ws.GenericWebSocketFrame;
import io.inverno.mod.http.server.internal.http1x.ws.GenericWebSocketMessage;
import io.inverno.mod.http.server.internal.http1x.ws.WebSocketProtocolHandler;
import io.inverno.mod.http.server.ws.WebSocket;
import io.inverno.mod.http.server.ws.WebSocketExchange;
import io.inverno.mod.http.server.ws.WebSocketExchangeHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class Http1xWebSocket
implements WebSocket<ExchangeContext, WebSocketExchange<ExchangeContext>> {
    private final HttpServerConfiguration configuration;
    private final ChannelHandlerContext context;
    private final Http1xExchange exchange;
    private final GenericWebSocketFrame.GenericFactory frameFactory;
    private final GenericWebSocketMessage.GenericFactory messageFactory;
    private final WebSocketServerProtocolConfig config;
    private WebSocketExchangeHandler<? super ExchangeContext, WebSocketExchange<ExchangeContext>> handler;
    private Mono<Void> fallback;
    private Map<String, ChannelHandler> initialChannelHandlers;

    public Http1xWebSocket(HttpServerConfiguration configuration, ChannelHandlerContext context, Http1xExchange exchange, GenericWebSocketFrame.GenericFactory frameFactory, GenericWebSocketMessage.GenericFactory messageFactory, String[] subProtocols) {
        this.configuration = configuration;
        this.context = context;
        this.exchange = exchange;
        this.frameFactory = frameFactory;
        this.messageFactory = messageFactory;
        WebSocketServerProtocolConfig.Builder webSocketConfigBuilder = WebSocketServerProtocolConfig.newBuilder().websocketPath(exchange.request().getPath()).subprotocols(subProtocols != null && subProtocols.length > 0 ? Arrays.stream(subProtocols).collect(Collectors.joining(",")) : null).checkStartsWith(false).handleCloseFrames(false).dropPongFrames(true).expectMaskedFrames(true).closeOnProtocolViolation(false).allowMaskMismatch(configuration.ws_allow_mask_mismatch()).forceCloseTimeoutMillis(configuration.ws_close_timeout()).maxFramePayloadLength(configuration.ws_max_frame_size().intValue()).allowExtensions(configuration.ws_frame_compression_enabled() || configuration.ws_message_compression_enabled());
        if (configuration.ws_handshake_timeout() > 0L) {
            webSocketConfigBuilder.handshakeTimeoutMillis(configuration.ws_handshake_timeout());
        }
        this.config = webSocketConfigBuilder.build();
    }

    Mono<Void> handshake() {
        return Mono.defer(() -> {
            WebSocketProtocolHandler webSocketProtocolHandler = new WebSocketProtocolHandler(this.config, this.handler, this.exchange, this.frameFactory, this.messageFactory);
            ChannelPipeline pipeline = this.context.pipeline();
            this.initialChannelHandlers = pipeline.toMap();
            LinkedList<Object> extensionHandshakers = new LinkedList<Object>();
            if (this.configuration.ws_frame_compression_enabled()) {
                extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.configuration.ws_frame_compression_level()));
            }
            if (this.configuration.ws_message_compression_enabled()) {
                extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.configuration.ws_message_compression_level(), this.configuration.ws_message_allow_server_window_size(), this.configuration.ws_message_prefered_client_window_size(), this.configuration.ws_message_allow_server_no_context(), this.configuration.ws_message_preferred_client_no_context()));
            }
            if (!extensionHandshakers.isEmpty()) {
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerExtensionHandler((WebSocketServerExtensionHandshaker[])extensionHandshakers.toArray(WebSocketServerExtensionHandshaker[]::new))});
            }
            pipeline.addLast(new ChannelHandler[]{webSocketProtocolHandler});
            this.context.fireChannelRead((Object)((Http1xRequest)this.exchange.request()).underlyingRequest);
            return webSocketProtocolHandler.getHandshake();
        });
    }

    public void restorePipeline() {
        if (this.initialChannelHandlers != null) {
            Iterator currentHandlerNamesIterator;
            ChannelPipeline pipeline = this.context.pipeline();
            for (String currentHandlerName : pipeline.toMap().keySet()) {
                if (this.initialChannelHandlers.containsKey(currentHandlerName)) continue;
                pipeline.remove(currentHandlerName);
            }
            Map currentChannelHandlers = pipeline.toMap();
            if (currentChannelHandlers.size() != this.initialChannelHandlers.size() && (currentHandlerNamesIterator = currentChannelHandlers.keySet().iterator()).hasNext()) {
                String currentHandlerName = (String)currentHandlerNamesIterator.next();
                for (Map.Entry<String, ChannelHandler> currentInitialHandler : this.initialChannelHandlers.entrySet()) {
                    if (!currentInitialHandler.getKey().equals(currentHandlerName)) {
                        pipeline.addBefore(currentHandlerName, currentInitialHandler.getKey(), currentInitialHandler.getValue());
                        continue;
                    }
                    if (!currentHandlerNamesIterator.hasNext()) break;
                    currentHandlerName = (String)currentHandlerNamesIterator.next();
                }
            }
        }
    }

    public Mono<Void> getFallback() {
        return this.fallback;
    }

    @Override
    public WebSocket<ExchangeContext, WebSocketExchange<ExchangeContext>> handler(WebSocketExchangeHandler<? super ExchangeContext, WebSocketExchange<ExchangeContext>> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public WebSocket<ExchangeContext, WebSocketExchange<ExchangeContext>> or(Mono<Void> fallback) {
        this.fallback = fallback;
        return this;
    }
}

