/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.ResponseTrailers;
import io.inverno.mod.http.server.internal.netty.LinkedHttpHeaders;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http1xResponseTrailers
implements ResponseTrailers {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final LinkedHttpHeaders underlyingTrailers;

    public Http1xResponseTrailers(HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.underlyingTrailers = new LinkedHttpHeaders();
    }

    LinkedHttpHeaders getUnderlyingTrailers() {
        return this.underlyingTrailers;
    }

    @Override
    public ResponseTrailers add(CharSequence name, CharSequence value) {
        this.underlyingTrailers.addCharSequence(name, value);
        return this;
    }

    @Override
    public ResponseTrailers add(Header ... trailers) {
        for (Header trailer : trailers) {
            this.underlyingTrailers.addCharSequence((CharSequence)trailer.getHeaderName(), trailer.getHeaderValue());
        }
        return this;
    }

    @Override
    public ResponseTrailers set(CharSequence name, CharSequence value) {
        this.underlyingTrailers.setCharSequence(name, value);
        return this;
    }

    @Override
    public ResponseTrailers set(Header ... trailers) {
        for (Header trailer : trailers) {
            this.underlyingTrailers.setCharSequence((CharSequence)trailer.getHeaderName(), trailer.getHeaderValue());
        }
        return this;
    }

    @Override
    public ResponseTrailers remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.underlyingTrailers.remove(name);
        }
        return this;
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.underlyingTrailers.contains(name);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingTrailers.contains(name, value, true);
    }

    @Override
    public Set<String> getNames() {
        return this.underlyingTrailers.names();
    }

    @Override
    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.underlyingTrailers.get(name));
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.underlyingTrailers.getAll(name);
    }

    @Override
    public List<Map.Entry<String, String>> getAll() {
        return this.underlyingTrailers.entries();
    }

    @Override
    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    @Override
    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    @Override
    public List<Header> getAllHeader() {
        return this.getAll().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    @Override
    public List<Parameter> getAllParameter(CharSequence name) {
        return this.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    @Override
    public List<Parameter> getAllParameter() {
        return this.getAll().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }
}

