/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.http.server.internal.netty.FlatHttpResponse;
import io.inverno.mod.http.server.internal.netty.LinkedHttpHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;
import java.util.List;

public class Http1xResponseEncoder
extends HttpResponseEncoder {
    private ChannelHandlerContext context;
    private final ByteBufAllocator byteBufAllocator;

    public Http1xResponseEncoder(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        super.encode(this.context, msg, out);
    }

    protected void encodeHeaders(HttpHeaders headers, ByteBuf buf) {
        if (headers instanceof LinkedHttpHeaders) {
            ((LinkedHttpHeaders)headers).encode(buf);
        } else {
            super.encodeHeaders(headers, buf);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.context = new ChannelHandlerContextProxy(ctx);
        super.handlerAdded(ctx);
    }

    protected boolean isContentAlwaysEmpty(HttpResponse msg) {
        return msg instanceof FlatHttpResponse && ((FlatHttpResponse)msg).isEmpty() || super.isContentAlwaysEmpty(msg);
    }

    private final class ChannelHandlerContextProxy
    implements ChannelHandlerContext {
        private final ChannelHandlerContext context;

        public ChannelHandlerContextProxy(ChannelHandlerContext context) {
            this.context = context;
        }

        public ChannelFuture bind(SocketAddress localAddress) {
            return this.context.bind(localAddress);
        }

        public ChannelFuture connect(SocketAddress remoteAddress) {
            return this.context.connect(remoteAddress);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
            return this.context.connect(remoteAddress, localAddress);
        }

        public ChannelFuture disconnect() {
            return this.context.disconnect();
        }

        public ChannelFuture close() {
            return this.context.close();
        }

        public ChannelFuture deregister() {
            return this.context.deregister();
        }

        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
            return this.context.bind(localAddress, promise);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
            return this.context.connect(remoteAddress, promise);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            return this.context.connect(remoteAddress, localAddress, promise);
        }

        public ChannelFuture disconnect(ChannelPromise promise) {
            return this.context.disconnect(promise);
        }

        public ChannelFuture close(ChannelPromise promise) {
            return this.context.close(promise);
        }

        public ChannelFuture deregister(ChannelPromise promise) {
            return this.context.deregister(promise);
        }

        public ChannelFuture write(Object msg) {
            return this.context.write(msg);
        }

        public ChannelFuture write(Object msg, ChannelPromise promise) {
            return this.context.write(msg, promise);
        }

        public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
            return this.context.writeAndFlush(msg, promise);
        }

        public ChannelFuture writeAndFlush(Object msg) {
            return this.context.writeAndFlush(msg);
        }

        public ChannelPromise newPromise() {
            return this.context.newPromise();
        }

        public ChannelProgressivePromise newProgressivePromise() {
            return this.context.newProgressivePromise();
        }

        public ChannelFuture newSucceededFuture() {
            return this.context.newSucceededFuture();
        }

        public ChannelFuture newFailedFuture(Throwable cause) {
            return this.context.newFailedFuture(cause);
        }

        public ChannelPromise voidPromise() {
            return this.context.voidPromise();
        }

        public Channel channel() {
            return this.context.channel();
        }

        public EventExecutor executor() {
            return this.context.executor();
        }

        public String name() {
            return this.context.name();
        }

        public ChannelHandler handler() {
            return this.context.handler();
        }

        public boolean isRemoved() {
            return this.context.isRemoved();
        }

        public ChannelHandlerContext fireChannelRegistered() {
            this.context.fireChannelRegistered();
            return this;
        }

        public ChannelHandlerContext fireChannelUnregistered() {
            this.context.fireChannelUnregistered();
            return this;
        }

        public ChannelHandlerContext fireChannelActive() {
            this.context.fireChannelActive();
            return this;
        }

        public ChannelHandlerContext fireChannelInactive() {
            this.context.fireChannelInactive();
            return this;
        }

        public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
            this.context.fireExceptionCaught(cause);
            return this;
        }

        public ChannelHandlerContext fireUserEventTriggered(Object evt) {
            this.context.fireUserEventTriggered(evt);
            return this;
        }

        public ChannelHandlerContext fireChannelRead(Object msg) {
            this.context.fireChannelRead(msg);
            return this;
        }

        public ChannelHandlerContext fireChannelReadComplete() {
            this.context.fireChannelReadComplete();
            return this;
        }

        public ChannelHandlerContext fireChannelWritabilityChanged() {
            this.context.fireChannelWritabilityChanged();
            return this;
        }

        public ChannelHandlerContext read() {
            this.context.read();
            return this;
        }

        public ChannelHandlerContext flush() {
            this.context.flush();
            return this;
        }

        public ChannelPipeline pipeline() {
            return this.context.pipeline();
        }

        public ByteBufAllocator alloc() {
            return Http1xResponseEncoder.this.byteBufAllocator;
        }

        @Deprecated
        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return this.context.channel().attr(key);
        }

        @Deprecated
        public <T> boolean hasAttr(AttributeKey<T> key) {
            return this.context.channel().hasAttr(key);
        }
    }
}

