/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server;

import io.inverno.core.v1.Module;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.NetService;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.http.base.Base;
import io.inverno.mod.http.base.header.HeaderCodec;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.HttpServerConfigurationLoader;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.HttpChannelConfigurer;
import io.inverno.mod.http.server.internal.HttpChannelInitializer;
import io.inverno.mod.http.server.internal.HttpServer;
import io.inverno.mod.http.server.internal.HttpServerController;
import io.inverno.mod.http.server.internal.ParameterConverter;
import io.inverno.mod.http.server.internal.SslCipherSuiteFilter;
import io.inverno.mod.http.server.internal.SslContextWrapper;
import io.inverno.mod.http.server.internal.http1x.Http1xChannelHandlerFactory;
import io.inverno.mod.http.server.internal.http2.Http2ChannelHandlerFactory;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.inverno.mod.http.server.internal.multipart.MultipartFormDataBodyDecoder;
import io.inverno.mod.http.server.internal.multipart.UrlEncodedBodyDecoder;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class Server
extends Module {
    private Base base = (Base)this.with((Module.ModuleLinker)new Base.Linker(Map.ofEntries(Map.entry("headerCodecs", Optional.of(() -> new Module.BeanAggregator().add((Collection)headerCodecs.orElse(() -> null).get()).toList())), Map.entry("parameterConverter", Optional.of(() -> (ObjectConverter)this.parameterConverter.get())))));
    private Module.Bean<HttpServerConfiguration> configuration;
    private Module.Bean<ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>>> controller;
    private Module.Bean<Http1xChannelHandlerFactory> http1xChannelHandlerFactory;
    private Module.Bean<Http2ChannelHandlerFactory> http2ChannelHandlerFactory;
    private Module.Bean<HttpChannelConfigurer> httpChannelConfigurer;
    private Module.Bean<HttpChannelInitializer> httpChannelInitializer;
    private Module.Bean<HttpServer> httpServer;
    private Module.Bean<MultipartFormDataBodyDecoder> multipartFormDataBodyDecoder;
    private Module.Bean<ObjectConverter<String>> parameterConverter;
    private Module.Bean<SslCipherSuiteFilter> sslCipherSuiteFilter;
    private Module.Bean<SslContext> sslContextWrapper;
    private Module.Bean<UrlEncodedBodyDecoder> urlEncodedBodyDecoder;

    private Server(@Module.Socket(name="headerCodecs", wiredTo={"multipartFormDataBodyDecoder", "httpChannelConfigurer", "http1xChannelHandlerFactory", "parameterConverter", "httpServer", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "http2ChannelHandlerFactory", "httpChannelInitializer", "configuration", "sslContextWrapper"}) Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs, @Module.Socket(name="netService", wiredTo={"httpChannelConfigurer", "http1xChannelHandlerFactory", "multipartFormDataBodyDecoder", "httpServer", "parameterConverter", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "http2ChannelHandlerFactory", "httpChannelInitializer", "configuration", "sslContextWrapper"}) Supplier<NetService> netService, @Module.Socket(name="resourceService", wiredTo={"multipartFormDataBodyDecoder", "httpChannelConfigurer", "http1xChannelHandlerFactory", "parameterConverter", "httpServer", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "http2ChannelHandlerFactory", "httpChannelInitializer", "configuration", "sslContextWrapper"}) Supplier<ResourceService> resourceService, @Module.Socket(name="configuration", wiredTo={"multipartFormDataBodyDecoder", "httpChannelConfigurer", "http1xChannelHandlerFactory", "parameterConverter", "httpServer", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "http2ChannelHandlerFactory", "httpChannelInitializer", "configuration", "sslContextWrapper"}) Optional<Supplier<HttpServerConfiguration>> configurationOverride, @Module.Socket(name="controller", wiredTo={"multipartFormDataBodyDecoder", "httpChannelConfigurer", "http1xChannelHandlerFactory", "parameterConverter", "httpServer", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "http2ChannelHandlerFactory", "httpChannelInitializer", "configuration", "sslContextWrapper"}) Optional<Supplier<ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>>>> controllerOverride, @Module.Socket(name="parameterConverter", wiredTo={"multipartFormDataBodyDecoder", "httpChannelConfigurer", "http1xChannelHandlerFactory", "parameterConverter", "httpServer", "controller", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "http2ChannelHandlerFactory", "httpChannelInitializer", "configuration", "sslContextWrapper"}) Optional<Supplier<ObjectConverter<String>>> parameterConverterOverride) {
        super("io.inverno.mod.http.server");
        this.configuration = this.with(Module.WrapperBeanBuilder.singleton((String)"configuration", () -> {
            HttpServerConfigurationLoader.Bean configuration = new HttpServerConfigurationLoader.Bean();
            return configuration;
        }).override(configurationOverride));
        this.controller = this.with(Module.WrapperBeanBuilder.singleton((String)"controller", () -> {
            HttpServerController controller = new HttpServerController();
            return controller;
        }).override(controllerOverride));
        this.http1xChannelHandlerFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"http1xChannelHandlerFactory", () -> {
            Http1xChannelHandlerFactory http1xChannelHandlerFactory = new Http1xChannelHandlerFactory((HttpServerConfiguration)this.configuration.get(), (ServerController)this.controller.get(), (HeaderService)this.base.headerService(), (ObjectConverter<String>)((ObjectConverter)this.parameterConverter.get()), (MultipartDecoder)this.urlEncodedBodyDecoder.get(), (MultipartDecoder)this.multipartFormDataBodyDecoder.get());
            return http1xChannelHandlerFactory;
        }));
        this.http2ChannelHandlerFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"http2ChannelHandlerFactory", () -> {
            Http2ChannelHandlerFactory http2ChannelHandlerFactory = new Http2ChannelHandlerFactory((HttpServerConfiguration)this.configuration.get(), (ServerController)this.controller.get(), (HeaderService)this.base.headerService(), (ObjectConverter<String>)((ObjectConverter)this.parameterConverter.get()), (MultipartDecoder)this.urlEncodedBodyDecoder.get(), (MultipartDecoder)this.multipartFormDataBodyDecoder.get());
            return http2ChannelHandlerFactory;
        }));
        this.httpChannelConfigurer = this.with(Module.ModuleBeanBuilder.singleton((String)"httpChannelConfigurer", () -> {
            HttpChannelConfigurer httpChannelConfigurer = new HttpChannelConfigurer((HttpServerConfiguration)this.configuration.get(), (NetService)netService.get(), () -> (SslContext)this.sslContextWrapper.get(), (Supplier)this.http1xChannelHandlerFactory.get(), (Supplier)this.http2ChannelHandlerFactory.get());
            return httpChannelConfigurer;
        }));
        this.httpChannelInitializer = this.with(Module.ModuleBeanBuilder.singleton((String)"httpChannelInitializer", () -> {
            HttpChannelInitializer httpChannelInitializer = new HttpChannelInitializer((HttpChannelConfigurer)this.httpChannelConfigurer.get());
            return httpChannelInitializer;
        }));
        this.httpServer = this.with((Module.ModuleBeanBuilder)((Module.ModuleBeanBuilder)Module.ModuleBeanBuilder.singleton((String)"httpServer", () -> {
            HttpServer httpServer = new HttpServer((HttpServerConfiguration)this.configuration.get(), (NetService)netService.get(), (ChannelInitializer<SocketChannel>)((ChannelInitializer)this.httpChannelInitializer.get()));
            return httpServer;
        }).init(HttpServer::start)).destroy(HttpServer::stop));
        this.multipartFormDataBodyDecoder = this.with(Module.ModuleBeanBuilder.singleton((String)"multipartFormDataBodyDecoder", () -> {
            MultipartFormDataBodyDecoder multipartFormDataBodyDecoder = new MultipartFormDataBodyDecoder((HeaderService)this.base.headerService(), (ObjectConverter<String>)((ObjectConverter)this.parameterConverter.get()));
            return multipartFormDataBodyDecoder;
        }));
        this.parameterConverter = this.with(Module.WrapperBeanBuilder.singleton((String)"parameterConverter", () -> {
            ParameterConverter parameterConverter = new ParameterConverter();
            return parameterConverter;
        }).override(parameterConverterOverride));
        this.sslCipherSuiteFilter = this.with(Module.ModuleBeanBuilder.singleton((String)"sslCipherSuiteFilter", () -> {
            SslCipherSuiteFilter sslCipherSuiteFilter = new SslCipherSuiteFilter((HttpServerConfiguration)this.configuration.get());
            return sslCipherSuiteFilter;
        }));
        this.sslContextWrapper = this.with((Module.WrapperBeanBuilder)Module.WrapperBeanBuilder.prototype((String)"sslContextWrapper", () -> {
            SslContextWrapper sslContextWrapper = new SslContextWrapper((HttpServerConfiguration)this.configuration.get(), (ResourceService)resourceService.get());
            Optional.of((SslCipherSuiteFilter)this.sslCipherSuiteFilter.get()).ifPresent(sslContextWrapper::setCipherSuiteFilter);
            return sslContextWrapper;
        }).init(SslContextWrapper::init));
        this.urlEncodedBodyDecoder = this.with(Module.ModuleBeanBuilder.singleton((String)"urlEncodedBodyDecoder", () -> {
            UrlEncodedBodyDecoder urlEncodedBodyDecoder = new UrlEncodedBodyDecoder((ObjectConverter<String>)((ObjectConverter)this.parameterConverter.get()));
            return urlEncodedBodyDecoder;
        }));
    }

    public HttpServerConfiguration configuration() {
        return (HttpServerConfiguration)this.configuration.get();
    }

    public ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>> controller() {
        return (ServerController)this.controller.get();
    }

    private Http1xChannelHandlerFactory http1xChannelHandlerFactory() {
        return (Http1xChannelHandlerFactory)this.http1xChannelHandlerFactory.get();
    }

    private Http2ChannelHandlerFactory http2ChannelHandlerFactory() {
        return (Http2ChannelHandlerFactory)this.http2ChannelHandlerFactory.get();
    }

    private HttpChannelConfigurer httpChannelConfigurer() {
        return (HttpChannelConfigurer)this.httpChannelConfigurer.get();
    }

    private HttpChannelInitializer httpChannelInitializer() {
        return (HttpChannelInitializer)((Object)this.httpChannelInitializer.get());
    }

    private HttpServer httpServer() {
        return (HttpServer)this.httpServer.get();
    }

    private MultipartFormDataBodyDecoder multipartFormDataBodyDecoder() {
        return (MultipartFormDataBodyDecoder)this.multipartFormDataBodyDecoder.get();
    }

    private ObjectConverter<String> parameterConverter() {
        return (ObjectConverter)this.parameterConverter.get();
    }

    private SslCipherSuiteFilter sslCipherSuiteFilter() {
        return (SslCipherSuiteFilter)this.sslCipherSuiteFilter.get();
    }

    private SslContext sslContextWrapper() {
        return (SslContext)this.sslContextWrapper.get();
    }

    private UrlEncodedBodyDecoder urlEncodedBodyDecoder() {
        return (UrlEncodedBodyDecoder)this.urlEncodedBodyDecoder.get();
    }

    public static final class Linker
    extends Module.ModuleLinker<Server> {
        public Linker(Map<String, Object> sockets) {
            super(sockets);
        }

        protected Server link() {
            return new Server((Optional)this.sockets.get("headerCodecs"), (Supplier)this.sockets.get("netService"), (Supplier)this.sockets.get("resourceService"), (Optional)this.sockets.get("configuration"), (Optional)this.sockets.get("controller"), (Optional)this.sockets.get("parameterConverter"));
        }
    }

    public static final class Builder
    extends Module.ModuleBuilder<Server> {
        private Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs = Optional.empty();
        private Supplier<NetService> netService;
        private Supplier<ResourceService> resourceService;
        private Optional<Supplier<HttpServerConfiguration>> configuration = Optional.empty();
        private Optional<Supplier<ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>>>> controller = Optional.empty();
        private Optional<Supplier<ObjectConverter<String>>> parameterConverter = Optional.empty();

        public Builder(NetService netService, ResourceService resourceService) {
            super(new Object[]{"netService", netService, "resourceService", resourceService});
            this.netService = () -> netService;
            this.resourceService = () -> resourceService;
        }

        protected Server doBuild() {
            return new Server(this.headerCodecs, this.netService, this.resourceService, this.configuration, this.controller, this.parameterConverter);
        }

        public Builder setHeaderCodecs(List<HeaderCodec<?>> headerCodecs) {
            this.headerCodecs = Optional.ofNullable(headerCodecs != null ? () -> headerCodecs : null);
            return this;
        }

        public Builder setConfiguration(HttpServerConfiguration configuration) {
            this.configuration = Optional.ofNullable(configuration != null ? () -> configuration : null);
            return this;
        }

        public Builder setController(ServerController<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>, ? extends ErrorExchange<? extends ExchangeContext>> controller) {
            this.controller = Optional.ofNullable(controller != null ? () -> controller : null);
            return this;
        }

        public Builder setParameterConverter(ObjectConverter<String> parameterConverter) {
            this.parameterConverter = Optional.ofNullable(parameterConverter != null ? () -> parameterConverter : null);
            return this;
        }
    }
}

