/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server;

import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeContext;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ExchangeInterceptor<A extends ExchangeContext, B extends Exchange<A>> {
    public Mono<? extends B> intercept(B var1);

    default public ExchangeInterceptor<A, B> andThen(ExchangeInterceptor<? super A, B> after) {
        return exchange -> this.intercept(exchange).flatMap(after::intercept);
    }

    default public ExchangeInterceptor<A, B> compose(ExchangeInterceptor<? super A, B> before) {
        return exchange -> before.intercept(exchange).flatMap(this::intercept);
    }

    @SafeVarargs
    public static <A extends ExchangeContext, B extends Exchange<A>> ExchangeInterceptor<A, B> of(ExchangeInterceptor<? super A, B> ... interceptors) {
        return exchange -> {
            Mono interceptorChain = null;
            for (ExchangeInterceptor interceptor : interceptors) {
                interceptorChain = interceptorChain == null ? interceptor.intercept(exchange) : interceptorChain.flatMap(interceptor::intercept);
            }
            return interceptorChain;
        };
    }
}

