/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.ws;

import io.inverno.mod.http.base.ws.WebSocketStatus;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.ws.WebSocketFrame;
import io.inverno.mod.http.server.ws.WebSocketMessage;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface WebSocketExchange<A extends ExchangeContext> {
    public Request request();

    public A context();

    public String getSubProtocol();

    public Inbound inbound();

    public Outbound outbound();

    default public void close() {
        this.close(WebSocketStatus.NORMAL_CLOSURE, WebSocketStatus.NORMAL_CLOSURE.getReason());
    }

    default public void close(WebSocketStatus status) {
        this.close(status.getCode(), status.getReason());
    }

    default public void close(short code) {
        this.close(code, null);
    }

    default public void close(String reason) {
        this.close(WebSocketStatus.NORMAL_CLOSURE.getCode(), reason);
    }

    default public void close(WebSocketStatus status, String reason) {
        this.close(status.getCode(), reason);
    }

    public void close(short var1, String var2);

    public WebSocketExchange<A> finalizer(Mono<Void> var1);

    public static interface Outbound {
        public void frames(Function<WebSocketFrame.Factory, Publisher<WebSocketFrame>> var1);

        public void messages(Function<WebSocketMessage.Factory, Publisher<WebSocketMessage>> var1);
    }

    public static interface Inbound {
        public Publisher<WebSocketFrame> frames();

        public Publisher<WebSocketMessage> messages();

        public Publisher<WebSocketMessage> textMessages();

        public Publisher<WebSocketMessage> binaryMessages();
    }
}

