/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.RequestHeaders;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http2RequestHeaders
implements RequestHeaders {
    private final Http2Headers underlyingHeaders;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;

    public Http2RequestHeaders(Http2Headers headers, HeaderService HeaderService2, ObjectConverter<String> parameterConverter) {
        this.underlyingHeaders = headers;
        this.headerService = HeaderService2;
        this.parameterConverter = parameterConverter;
    }

    Http2Headers getUnderlyingHeaders() {
        return this.underlyingHeaders;
    }

    private String getHeaderValue(String name) {
        CharSequence header = (CharSequence)this.underlyingHeaders.get((Object)name);
        return header != null ? header.toString() : null;
    }

    @Override
    public String getContentType() {
        return this.getHeaderValue("content-type");
    }

    @Override
    public Long getContentLength() {
        return this.underlyingHeaders.getLong((Object)"content-length");
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.underlyingHeaders.contains((Object)name);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingHeaders.contains(name, value, true);
    }

    @Override
    public Set<String> getNames() {
        return this.underlyingHeaders.names().stream().map(CharSequence::toString).collect(Collectors.toSet());
    }

    @Override
    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable((CharSequence)this.underlyingHeaders.get((Object)name)).map(Object::toString);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(CharSequence::toString).collect(Collectors.toList());
    }

    @Override
    public List<Map.Entry<String, String>> getAll() {
        LinkedList<Map.Entry<String, String>> result = new LinkedList<Map.Entry<String, String>>();
        this.underlyingHeaders.forEach(e -> result.add(Map.entry(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    @Override
    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    @Override
    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(value -> this.headerService.decode(name.toString(), value.toString())).collect(Collectors.toList());
    }

    @Override
    public List<Header> getAllHeader() {
        LinkedList<Header> result = new LinkedList<Header>();
        this.underlyingHeaders.forEach(e -> result.add(this.headerService.decode(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    @Override
    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    @Override
    public List<Parameter> getAllParameter(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(value -> new GenericParameter(name.toString(), value.toString(), this.parameterConverter)).collect(Collectors.toList());
    }

    @Override
    public List<Parameter> getAllParameter() {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        this.underlyingHeaders.forEach(e -> result.add((Parameter)new GenericParameter(((CharSequence)e.getValue()).toString(), ((CharSequence)e.getValue()).toString(), this.parameterConverter)));
        return result;
    }
}

