/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x.ws;

import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.internal.http1x.ws.GenericWebSocketFrame;
import io.inverno.mod.http.server.ws.WebSocketFrame;
import io.inverno.mod.http.server.ws.WebSocketMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericWebSocketMessage
implements WebSocketMessage {
    private final WebSocketMessage.Kind kind;
    private final Publisher<io.inverno.mod.http.server.ws.WebSocketFrame> frames;

    public GenericWebSocketMessage(WebSocketMessage.Kind kind, Publisher<io.inverno.mod.http.server.ws.WebSocketFrame> frames) {
        this.kind = kind;
        this.frames = frames;
    }

    @Override
    public WebSocketMessage.Kind getKind() {
        return this.kind;
    }

    @Override
    public Publisher<io.inverno.mod.http.server.ws.WebSocketFrame> frames() {
        return this.frames;
    }

    @Override
    public Publisher<ByteBuf> binary() {
        return Flux.from(this.frames).map(io.inverno.mod.http.server.ws.WebSocketFrame::getBinaryData);
    }

    @Override
    public Mono<ByteBuf> reducedBinary() {
        return Flux.from(this.binary()).reduceWith(() -> Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer()), (acc, chunk) -> {
            try {
                ByteBuf byteBuf = acc.writeBytes(chunk);
                return byteBuf;
            }
            finally {
                chunk.release();
            }
        });
    }

    @Override
    public Publisher<String> text() {
        return Flux.from(this.frames).map(frame -> {
            try {
                String string = frame.getTextData();
                return string;
            }
            finally {
                frame.release();
            }
        });
    }

    @Override
    public Mono<String> reducedText() {
        return Flux.from(this.text()).reduceWith(() -> new StringBuilder(), (acc, chunk) -> acc.append((String)chunk)).map(StringBuilder::toString);
    }

    public static final class GenericFactory
    implements WebSocketMessage.Factory {
        private final int maxFrameSize;

        public GenericFactory(HttpServerConfiguration configuration) {
            this.maxFrameSize = configuration.ws_max_frame_size();
        }

        @Override
        public WebSocketMessage text(String value) {
            return new GenericWebSocketMessage(WebSocketMessage.Kind.TEXT, (Publisher<io.inverno.mod.http.server.ws.WebSocketFrame>)Flux.fromStream(() -> this.toTextFrames(Unpooled.copiedBuffer((CharSequence)value, (Charset)CharsetUtil.UTF_8), true, true).stream()));
        }

        @Override
        public WebSocketMessage text(Publisher<String> stream) {
            Flux frames = stream instanceof Mono ? ((Mono)stream).flatMapIterable(value -> this.toTextFrames(Unpooled.copiedBuffer((CharSequence)value, (Charset)CharsetUtil.UTF_8), true, true)) : Flux.defer(() -> {
                AtomicBoolean first = new AtomicBoolean(true);
                return Flux.from((Publisher)stream).flatMapIterable(value -> this.toTextFrames(Unpooled.copiedBuffer((CharSequence)value, (Charset)CharsetUtil.UTF_8), first.getAndSet(false), false)).concatWithValues((Object[])new io.inverno.mod.http.server.ws.WebSocketFrame[]{new GenericWebSocketFrame((WebSocketFrame)new ContinuationWebSocketFrame(true, 0, Unpooled.EMPTY_BUFFER), WebSocketFrame.Kind.CONTINUATION)});
            });
            return new GenericWebSocketMessage(WebSocketMessage.Kind.TEXT, (Publisher<io.inverno.mod.http.server.ws.WebSocketFrame>)frames);
        }

        @Override
        public WebSocketMessage text_raw(ByteBuf value) {
            return new GenericWebSocketMessage(WebSocketMessage.Kind.TEXT, (Publisher<io.inverno.mod.http.server.ws.WebSocketFrame>)Flux.fromStream(() -> this.toTextFrames(value, true, true).stream()));
        }

        @Override
        public WebSocketMessage text_raw(Publisher<ByteBuf> stream) {
            Flux frames = stream instanceof Mono ? ((Mono)stream).flatMapIterable(value -> this.toTextFrames((ByteBuf)value, true, true)) : Flux.defer(() -> {
                AtomicBoolean first = new AtomicBoolean(true);
                return Flux.from((Publisher)stream).flatMapIterable(value -> this.toTextFrames((ByteBuf)value, first.getAndSet(false), false)).concatWithValues((Object[])new io.inverno.mod.http.server.ws.WebSocketFrame[]{new GenericWebSocketFrame((WebSocketFrame)new ContinuationWebSocketFrame(true, 0, Unpooled.EMPTY_BUFFER), WebSocketFrame.Kind.CONTINUATION)});
            });
            return new GenericWebSocketMessage(WebSocketMessage.Kind.TEXT, (Publisher<io.inverno.mod.http.server.ws.WebSocketFrame>)frames);
        }

        @Override
        public WebSocketMessage binary(ByteBuf value) {
            return new GenericWebSocketMessage(WebSocketMessage.Kind.BINARY, (Publisher<io.inverno.mod.http.server.ws.WebSocketFrame>)Flux.fromStream(() -> this.toBinaryFrames(value, true, true).stream()));
        }

        @Override
        public WebSocketMessage binary(Publisher<ByteBuf> stream) {
            Flux frames = stream instanceof Mono ? ((Mono)stream).flatMapIterable(value -> this.toBinaryFrames((ByteBuf)value, true, true)) : Flux.defer(() -> {
                AtomicBoolean first = new AtomicBoolean(true);
                return Flux.from((Publisher)stream).flatMapIterable(value -> this.toBinaryFrames((ByteBuf)value, first.getAndSet(false), false)).concatWithValues((Object[])new io.inverno.mod.http.server.ws.WebSocketFrame[]{new GenericWebSocketFrame((WebSocketFrame)new ContinuationWebSocketFrame(true, 0, Unpooled.EMPTY_BUFFER), WebSocketFrame.Kind.CONTINUATION)});
            });
            return new GenericWebSocketMessage(WebSocketMessage.Kind.TEXT, (Publisher<io.inverno.mod.http.server.ws.WebSocketFrame>)frames);
        }

        private List<io.inverno.mod.http.server.ws.WebSocketFrame> toTextFrames(ByteBuf data, boolean isFirst, boolean isFinal) {
            int size = data.readableBytes();
            if (size > this.maxFrameSize) {
                int framesCount = (int)Math.ceil((double)size / (double)this.maxFrameSize);
                ArrayList<io.inverno.mod.http.server.ws.WebSocketFrame> frames = new ArrayList<io.inverno.mod.http.server.ws.WebSocketFrame>(framesCount);
                for (int i = 0; i < framesCount; ++i) {
                    int offset = i * this.maxFrameSize;
                    int length = Math.min(this.maxFrameSize, size - offset);
                    ByteBuf framePayload = data.retainedSlice(offset, length);
                    if (isFirst && i == 0) {
                        frames.add(new GenericWebSocketFrame((WebSocketFrame)new TextWebSocketFrame(false, 0, framePayload), WebSocketFrame.Kind.TEXT));
                        continue;
                    }
                    frames.add(new GenericWebSocketFrame((WebSocketFrame)new ContinuationWebSocketFrame(isFinal && i == framesCount - 1, 0, framePayload), WebSocketFrame.Kind.CONTINUATION));
                }
                return frames;
            }
            if (isFirst) {
                return List.of(new GenericWebSocketFrame((WebSocketFrame)new TextWebSocketFrame(isFinal, 0, data), WebSocketFrame.Kind.TEXT));
            }
            return List.of(new GenericWebSocketFrame((WebSocketFrame)new ContinuationWebSocketFrame(isFinal, 0, data), WebSocketFrame.Kind.TEXT));
        }

        private List<io.inverno.mod.http.server.ws.WebSocketFrame> toBinaryFrames(ByteBuf data, boolean isFirst, boolean isFinal) {
            int size = data.readableBytes();
            if (size > this.maxFrameSize) {
                int framesCount = (int)Math.ceil((double)size / (double)this.maxFrameSize);
                ArrayList<io.inverno.mod.http.server.ws.WebSocketFrame> frames = new ArrayList<io.inverno.mod.http.server.ws.WebSocketFrame>(framesCount);
                for (int i = 0; i < framesCount; ++i) {
                    int offset = i * this.maxFrameSize;
                    int length = Math.min(this.maxFrameSize, size - offset);
                    ByteBuf framePayload = data.retainedSlice(offset, length);
                    if (isFirst && i == 0) {
                        frames.add(new GenericWebSocketFrame((WebSocketFrame)new BinaryWebSocketFrame(false, 0, framePayload), WebSocketFrame.Kind.TEXT));
                        continue;
                    }
                    frames.add(new GenericWebSocketFrame((WebSocketFrame)new ContinuationWebSocketFrame(isFinal && i == framesCount - 1, 0, framePayload), WebSocketFrame.Kind.CONTINUATION));
                }
                return frames;
            }
            if (isFirst) {
                return List.of(new GenericWebSocketFrame((WebSocketFrame)new BinaryWebSocketFrame(isFinal, 0, data), WebSocketFrame.Kind.TEXT));
            }
            return List.of(new GenericWebSocketFrame((WebSocketFrame)new ContinuationWebSocketFrame(isFinal, 0, data), WebSocketFrame.Kind.TEXT));
        }
    }
}

