/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.ResponseHeaders;
import io.inverno.mod.http.server.internal.AbstractResponseHeaders;
import io.inverno.mod.http.server.internal.netty.LinkedHttpHeaders;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http1xResponseHeaders
implements AbstractResponseHeaders {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final LinkedHttpHeaders underlyingHeaders;
    private int statusCode = 200;
    private boolean written;

    public Http1xResponseHeaders(HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.underlyingHeaders = new LinkedHttpHeaders();
    }

    LinkedHttpHeaders getUnderlyingHeaders() {
        return this.underlyingHeaders;
    }

    @Override
    public Http1xResponseHeaders status(Status status) {
        return this.status(status.getCode());
    }

    @Override
    public Http1xResponseHeaders status(int status) {
        this.statusCode = status;
        return this;
    }

    @Override
    public Http1xResponseHeaders contentType(String contentType) {
        this.underlyingHeaders.set((CharSequence)"content-type", (Object)contentType);
        return this;
    }

    @Override
    public Http1xResponseHeaders contentLength(long contentLength) {
        this.underlyingHeaders.setLong("content-length", contentLength);
        return this;
    }

    @Override
    public Http1xResponseHeaders add(CharSequence name, CharSequence value) {
        this.underlyingHeaders.addCharSequence(name, value);
        return this;
    }

    @Override
    public Http1xResponseHeaders add(Header ... headers) {
        for (Header header : headers) {
            this.underlyingHeaders.addCharSequence((CharSequence)header.getHeaderName(), header.getHeaderValue());
        }
        return this;
    }

    @Override
    public ResponseHeaders set(CharSequence name, CharSequence value) {
        this.underlyingHeaders.setCharSequence(name, value);
        return this;
    }

    @Override
    public ResponseHeaders set(Header ... headers) {
        for (Header header : headers) {
            this.underlyingHeaders.setCharSequence((CharSequence)header.getHeaderName(), header.getHeaderValue());
        }
        return this;
    }

    @Override
    public ResponseHeaders remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.underlyingHeaders.remove(name);
        }
        return this;
    }

    @Override
    public boolean isWritten() {
        return this.written;
    }

    @Override
    public void setWritten(boolean written) {
        this.written = written;
    }

    @Override
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.underlyingHeaders.get((CharSequence)"content-type"));
    }

    @Override
    public Optional<Headers.ContentType> getContentTypeHeader() {
        return this.getHeader("content-type");
    }

    @Override
    public CharSequence getContentTypeCharSequence() {
        return this.underlyingHeaders.getCharSequence("content-type");
    }

    @Override
    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    @Override
    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.underlyingHeaders.get(name));
    }

    @Override
    public CharSequence getCharSequence(CharSequence name) {
        return this.underlyingHeaders.getCharSequence(name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.underlyingHeaders.getAll(name);
    }

    @Override
    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    @Override
    public List<CharSequence> getAllCharSequence(CharSequence name) {
        return this.underlyingHeaders.getAllCharSequence(name);
    }

    @Override
    public List<Map.Entry<String, String>> getAll() {
        return this.underlyingHeaders.entries();
    }

    @Override
    public List<Header> getAllHeader() {
        return this.getAll().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public List<Map.Entry<CharSequence, CharSequence>> getAllCharSequence() {
        return this.underlyingHeaders.entriesCharSequence();
    }

    @Override
    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    @Override
    public List<Parameter> getAllParameter(CharSequence name) {
        return this.underlyingHeaders.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    @Override
    public List<Parameter> getAllParameter() {
        return this.underlyingHeaders.entries().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }

    @Override
    public Set<String> getNames() {
        return this.underlyingHeaders.names();
    }

    @Override
    public Long getContentLength() {
        return this.underlyingHeaders.getLong("content-length");
    }

    @Override
    public Status getStatus() {
        return Status.valueOf((int)this.statusCode);
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.underlyingHeaders.contains(name);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingHeaders.contains(name, value, true);
    }
}

