/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xConnectionEncoder;
import io.inverno.mod.http.server.internal.http1x.Http1xExchange;
import io.inverno.mod.http.server.internal.http1x.ws.GenericWebSocketFrame;
import io.inverno.mod.http.server.internal.http1x.ws.GenericWebSocketMessage;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.concurrent.GenericFutureListener;
import reactor.core.publisher.Sinks;

public class Http1xChannelHandler
extends ChannelDuplexHandler
implements Http1xConnectionEncoder,
AbstractExchange.Handler {
    private final HttpServerConfiguration configuration;
    private final ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private final GenericWebSocketFrame.GenericFactory webSocketFrameFactory;
    private final GenericWebSocketMessage.GenericFactory webSocketMessageFactory;
    private Http1xExchange requestingExchange;
    private Http1xExchange respondingExchange;
    private Http1xExchange exchangeQueue;
    private boolean read;
    private boolean flush;

    public Http1xChannelHandler(HttpServerConfiguration configuration, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, GenericWebSocketFrame.GenericFactory webSocketFrameFactory, GenericWebSocketMessage.GenericFactory webSocketMessageFactory) {
        this.configuration = configuration;
        this.controller = controller;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.webSocketFrameFactory = webSocketFrameFactory;
        this.webSocketMessageFactory = webSocketMessageFactory;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpObject) {
            this.read = true;
            if (msg instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)msg;
                if (httpRequest.decoderResult().isFailure()) {
                    this.onDecoderError(ctx, httpRequest.protocolVersion(), (HttpObject)httpRequest);
                    return;
                }
                this.requestingExchange = new Http1xExchange(this.configuration, ctx, httpRequest.protocolVersion(), httpRequest, this, this.headerService, this.parameterConverter, this.urlEncodedBodyDecoder, this.multipartBodyDecoder, this.controller, this.webSocketFrameFactory, this.webSocketMessageFactory);
                if (this.exchangeQueue == null) {
                    this.exchangeQueue = this.requestingExchange;
                    this.requestingExchange.start(this);
                } else {
                    this.exchangeQueue.next = this.requestingExchange;
                    this.exchangeQueue = this.requestingExchange;
                }
            } else if (this.requestingExchange != null) {
                HttpVersion version = this.requestingExchange.version;
                if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
                    this.requestingExchange.request().data().ifPresent(sink -> sink.tryEmitComplete());
                } else {
                    HttpContent httpContent = (HttpContent)msg;
                    if (httpContent.decoderResult().isFailure()) {
                        this.onDecoderError(ctx, version, (HttpObject)httpContent);
                        return;
                    }
                    this.requestingExchange.request().data().ifPresentOrElse(sink -> {
                        if (sink.tryEmitNext((Object)httpContent.content()) != Sinks.EmitResult.OK) {
                            httpContent.release();
                        }
                    }, () -> httpContent.release());
                    if (httpContent instanceof LastHttpContent) {
                        this.requestingExchange.request().data().ifPresent(sink -> sink.tryEmitComplete());
                    }
                }
            } else {
                ((HttpContent)msg).release();
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.read) {
            this.read = false;
            if (this.flush) {
                ctx.flush();
                this.flush = false;
            }
        }
    }

    private void onDecoderError(ChannelHandlerContext ctx, HttpVersion version, HttpObject httpObject) {
        Throwable cause = httpObject.decoderResult().cause();
        if (cause instanceof TooLongFrameException) {
            String causeMsg = cause.getMessage();
            HttpResponseStatus status = causeMsg.startsWith("An HTTP line is larger than") ? HttpResponseStatus.REQUEST_URI_TOO_LONG : (causeMsg.startsWith("HTTP header is larger than") ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
            ChannelPromise writePromise = ctx.newPromise();
            ctx.write((Object)new DefaultFullHttpResponse(version, status), writePromise);
            writePromise.addListener(res -> ctx.fireExceptionCaught(cause));
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireUserEventTriggered(evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof WebSocketHandshakeException || cause instanceof CorruptedWebSocketFrameException) {
            super.exceptionCaught(ctx, cause);
        } else if (this.respondingExchange != null) {
            this.respondingExchange.dispose();
            ChannelPromise errorPromise = ctx.newPromise();
            this.respondingExchange.finalizeExchange(errorPromise, () -> ctx.close());
            errorPromise.tryFailure(cause);
        } else {
            ctx.close();
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.exchangeQueue != null) {
            this.exchangeQueue.next = null;
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.read) {
            this.flush = true;
            return ctx.write(msg, promise);
        }
        return ctx.writeAndFlush(msg, promise);
    }

    @Override
    public void exchangeStart(ChannelHandlerContext ctx, AbstractExchange exchange) {
        this.respondingExchange = (Http1xExchange)exchange;
    }

    @Override
    public void exchangeError(ChannelHandlerContext ctx, Throwable t) {
        if (this.flush) {
            ctx.flush();
        }
        if (this.respondingExchange.next != null) {
            this.respondingExchange.next.dispose();
        }
        ctx.close();
    }

    @Override
    public void exchangeComplete(ChannelHandlerContext ctx) {
        if (this.respondingExchange.keepAlive) {
            if (this.respondingExchange.next != null) {
                this.respondingExchange.next.start(this);
            } else {
                this.exchangeQueue = null;
                this.respondingExchange = null;
            }
        } else {
            if (this.respondingExchange.next != null) {
                this.respondingExchange.next.dispose();
            }
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

