/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.RequestBody;
import io.inverno.mod.http.server.RequestData;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericRequestBody
implements RequestBody {
    private final Optional<Headers.ContentType> contentType;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private Flux<ByteBuf> data;
    private RequestData<ByteBuf> rawData;
    private RequestData<CharSequence> stringData;
    private RequestBody.UrlEncoded urlEncodedData;
    private RequestBody.Multipart<Part> multipartData;

    public GenericRequestBody(Optional<Headers.ContentType> contentType, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, Flux<ByteBuf> data) {
        this.contentType = contentType;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.data = data;
    }

    @Override
    public RequestBody transform(Function<Publisher<ByteBuf>, Publisher<ByteBuf>> transformer) {
        this.data = Flux.from(transformer.apply((Publisher<ByteBuf>)this.data));
        return this;
    }

    @Override
    public RequestData<ByteBuf> raw() {
        if (this.rawData == null) {
            this.rawData = new GenericRequestBodyRawData();
        }
        return this.rawData;
    }

    @Override
    public RequestData<CharSequence> string() throws IllegalStateException {
        if (this.stringData == null) {
            this.stringData = new GenericRequestBodyStringData();
        }
        return this.stringData;
    }

    public RequestBody.Multipart<Part> multipart() {
        if (this.multipartData == null) {
            this.multipartData = new GenericRequestBodyMultipartData((Publisher<Part>)this.multipartBodyDecoder.decode(this.data, this.contentType.orElse(null)));
        }
        return this.multipartData;
    }

    @Override
    public RequestBody.UrlEncoded urlEncoded() {
        if (this.urlEncodedData == null) {
            this.urlEncodedData = new GenericRequestBodyUrlEncodedData((Publisher<Parameter>)this.urlEncodedBodyDecoder.decode(this.data, this.contentType.orElse(null)));
        }
        return this.urlEncodedData;
    }

    private class GenericRequestBodyRawData
    implements RequestData<ByteBuf> {
        private GenericRequestBodyRawData() {
        }

        @Override
        public Publisher<ByteBuf> stream() {
            return GenericRequestBody.this.data;
        }
    }

    private class GenericRequestBodyStringData
    implements RequestData<CharSequence> {
        private GenericRequestBodyStringData() {
        }

        @Override
        public Publisher<CharSequence> stream() {
            return GenericRequestBody.this.data.map(buf -> {
                try {
                    String string = buf.toString(Charsets.DEFAULT);
                    return string;
                }
                finally {
                    buf.release();
                }
            });
        }
    }

    private class GenericRequestBodyMultipartData
    implements RequestBody.Multipart<Part> {
        private Publisher<Part> parts;

        public GenericRequestBodyMultipartData(Publisher<Part> parts) {
            this.parts = parts;
        }

        @Override
        public Publisher<Part> stream() {
            return this.parts;
        }
    }

    private class GenericRequestBodyUrlEncodedData
    implements RequestBody.UrlEncoded {
        private final Publisher<Parameter> parameters;
        private Mono<Map<String, Parameter>> parametersMap;

        public GenericRequestBodyUrlEncodedData(Publisher<Parameter> parameters) {
            this.parameters = Flux.from(parameters).cache();
        }

        @Override
        public Publisher<Parameter> stream() {
            return this.parameters;
        }

        @Override
        public Mono<Map<String, Parameter>> collectMap() {
            if (this.parametersMap == null) {
                this.parametersMap = Flux.from(this.parameters).collectMap(Parameter::getName).cache();
            }
            return this.parametersMap;
        }
    }
}

