/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.ResponseCookies;
import io.inverno.mod.http.server.ResponseHeaders;
import io.inverno.mod.http.server.ResponseTrailers;
import io.inverno.mod.http.server.internal.AbstractResponseHeaders;
import io.inverno.mod.http.server.internal.GenericResponseBody;
import io.inverno.mod.http.server.internal.GenericResponseCookies;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;

public abstract class AbstractResponse
implements Response {
    protected final ChannelHandlerContext context;
    protected final HeaderService headerService;
    protected final AbstractResponseHeaders responseHeaders;
    protected GenericResponseBody responseBody;
    protected ResponseTrailers responseTrailers;
    protected GenericResponseCookies responseCookies;

    public AbstractResponse(ChannelHandlerContext context, HeaderService headerService, AbstractResponseHeaders responseHeaders) {
        this.context = context;
        this.headerService = headerService;
        this.responseHeaders = responseHeaders;
    }

    public boolean isSingle() {
        return this.responseBody.isSingle();
    }

    public void dataSubscribe(Subscriber<ByteBuf> s) {
        this.responseBody.dataSubscribe(s);
    }

    public GenericResponseCookies getCookies() {
        return this.responseCookies;
    }

    @Override
    public boolean isHeadersWritten() {
        return this.responseHeaders.isWritten();
    }

    @Override
    public AbstractResponseHeaders headers() {
        return this.responseHeaders;
    }

    @Override
    public AbstractResponse headers(Consumer<ResponseHeaders> headersConfigurer) {
        if (this.isHeadersWritten()) {
            throw new IllegalStateException("Headers already written");
        }
        headersConfigurer.accept(this.responseHeaders);
        return this;
    }

    @Override
    public ResponseTrailers trailers() {
        return this.responseTrailers;
    }

    @Override
    public AbstractResponse cookies(Consumer<ResponseCookies> cookiesConfigurer) {
        if (this.isHeadersWritten()) {
            throw new IllegalStateException("Headers already written");
        }
        if (this.responseCookies == null) {
            this.responseCookies = new GenericResponseCookies(this.headerService, this.responseHeaders);
        }
        cookiesConfigurer.accept(this.responseCookies);
        return this;
    }

    @Override
    public GenericResponseBody body() {
        return this.responseBody;
    }
}

