/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.URIBuilder;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.QueryParameters;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.RequestBody;
import io.inverno.mod.http.server.RequestCookies;
import io.inverno.mod.http.server.RequestHeaders;
import io.inverno.mod.http.server.internal.GenericQueryParameters;
import io.inverno.mod.http.server.internal.GenericRequestBody;
import io.inverno.mod.http.server.internal.GenericRequestCookies;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCounted;
import java.net.SocketAddress;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public abstract class AbstractRequest
implements Request {
    protected final ChannelHandlerContext context;
    protected final RequestHeaders requestHeaders;
    protected final ObjectConverter<String> parameterConverter;
    protected final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    protected final MultipartDecoder<Part> multipartBodyDecoder;
    protected GenericQueryParameters queryParameters;
    protected GenericRequestCookies requestCookies;
    private Optional<RequestBody> requestBody;
    private Optional<Sinks.Many<ByteBuf>> data;
    private boolean subscribed;
    private String pathAbsolute;
    private String queryString;

    public AbstractRequest(ChannelHandlerContext context, RequestHeaders requestHeaders, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        this.context = context;
        this.requestHeaders = requestHeaders;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.data = Optional.empty();
    }

    protected abstract URIBuilder getPrimaryPathBuilder();

    @Override
    public RequestHeaders headers() {
        return this.requestHeaders;
    }

    @Override
    public QueryParameters queryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new GenericQueryParameters(this.getPrimaryPathBuilder().getQueryParameters(new Object[0]), this.parameterConverter);
        }
        return this.queryParameters;
    }

    @Override
    public RequestCookies cookies() {
        if (this.requestCookies == null) {
            this.requestCookies = new GenericRequestCookies(this.requestHeaders, this.parameterConverter);
        }
        return this.requestCookies;
    }

    @Override
    public String getPathAbsolute() {
        if (this.pathAbsolute == null) {
            this.pathAbsolute = this.getPrimaryPathBuilder().buildRawPath();
        }
        return this.pathAbsolute;
    }

    @Override
    public URIBuilder getPathBuilder() {
        return this.getPrimaryPathBuilder().clone();
    }

    @Override
    public String getQuery() {
        if (this.queryString == null) {
            this.queryString = this.getPrimaryPathBuilder().buildRawQuery();
        }
        return this.queryString;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.context.channel().localAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.context.channel().remoteAddress();
    }

    public Optional<RequestBody> body() {
        if (this.requestBody == null) {
            Method method = this.getMethod();
            switch (method) {
                case POST: 
                case PUT: 
                case PATCH: 
                case DELETE: {
                    if (this.requestBody != null) break;
                    Sinks.Many dataSink = Sinks.many().unicast().onBackpressureBuffer();
                    Flux requestBodyData = dataSink.asFlux().doOnSubscribe(ign -> {
                        this.subscribed = true;
                    }).doOnDiscard(ByteBuf.class, ReferenceCounted::release);
                    this.data = Optional.of(dataSink);
                    this.requestBody = Optional.of(new GenericRequestBody(this.headers().getHeader("content-type"), this.urlEncodedBodyDecoder, this.multipartBodyDecoder, (Flux<ByteBuf>)requestBodyData));
                    break;
                }
                default: {
                    this.requestBody = Optional.empty();
                }
            }
        }
        return this.requestBody;
    }

    public Optional<Sinks.Many<ByteBuf>> data() {
        return this.data;
    }

    public void dispose() {
        this.data.ifPresent(dataSink -> {
            dataSink.tryEmitComplete();
            if (!this.subscribed) {
                dataSink.asFlux().subscribe(chunk -> chunk.release(), ex -> {});
            }
        });
        this.data = Optional.empty();
    }
}

