/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server;

import io.inverno.mod.configuration.Configuration;
import java.net.URI;

@Configuration(name="configuration")
public interface HttpServerConfiguration {
    default public String server_host() {
        return "0.0.0.0";
    }

    default public int server_port() {
        return 8080;
    }

    public Integer server_event_loop_group_size();

    default public boolean compression_enabled() {
        return false;
    }

    default public boolean decompression_enabled() {
        return false;
    }

    default public int compression_contentSizeThreshold() {
        return 0;
    }

    default public int compression_deflate_compressionLevel() {
        return 6;
    }

    default public int compression_deflate_windowBits() {
        return 15;
    }

    default public int compression_deflate_memLevel() {
        return 8;
    }

    default public int compression_gzip_compressionLevel() {
        return 6;
    }

    default public int compression_gzip_windowBits() {
        return 15;
    }

    default public int compression_gzip_memLevel() {
        return 8;
    }

    default public int compression_zstd_blockSize() {
        return 65536;
    }

    default public int compression_zstd_compressionLevel() {
        return 3;
    }

    default public int compression_zstd_maxEncodeSize() {
        return 0x2000000;
    }

    default public boolean tls_enabled() {
        return false;
    }

    default public long tls_handshake_timeout() {
        return 10000L;
    }

    default public boolean h2c_enabled() {
        return false;
    }

    default public boolean h2_enabled() {
        return true;
    }

    public URI key_store();

    default public String key_store_type() {
        return "JKS";
    }

    public String key_store_password();

    public String[] tls_ciphers_includes();

    public String[] tls_ciphers_excludes();

    default public Long http2_header_table_size() {
        return 4096L;
    }

    default public Integer http2_max_concurrent_streams() {
        return 100;
    }

    default public Integer http2_initial_window_size() {
        return 65535;
    }

    default public Integer http2_max_frame_size() {
        return 16384;
    }

    default public Integer http2_max_header_list_size() {
        return Integer.MAX_VALUE;
    }

    default public long ws_handshake_timeout() {
        return -1L;
    }

    default public long ws_close_timeout() {
        return -1L;
    }

    default public Integer ws_max_frame_size() {
        return 65536;
    }

    default public boolean ws_allow_mask_mismatch() {
        return false;
    }

    default public boolean ws_frame_compression_enabled() {
        return false;
    }

    default public int ws_frame_compression_level() {
        return 6;
    }

    default public boolean ws_message_compression_enabled() {
        return false;
    }

    default public int ws_message_compression_level() {
        return 6;
    }

    default public boolean ws_message_allow_server_window_size() {
        return false;
    }

    default public int ws_message_prefered_client_window_size() {
        return 15;
    }

    default public boolean ws_message_allow_server_no_context() {
        return false;
    }

    default public boolean ws_message_preferred_client_no_context() {
        return false;
    }
}

