/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server;

import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.ws.WebSocket;
import io.inverno.mod.http.server.ws.WebSocketExchange;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public interface ErrorExchange<A extends ExchangeContext>
extends Exchange<A> {
    public Throwable getError();

    @Override
    default public Optional<? extends WebSocket<A, ? extends WebSocketExchange<A>>> webSocket(String ... subProtocols) {
        return Optional.empty();
    }

    default public ErrorExchange<A> mapError(final Function<? super Throwable, ? extends Throwable> errorMapper) {
        final ErrorExchange thisExchange = this;
        return new ErrorExchange<A>(){

            @Override
            public Request request() {
                return thisExchange.request();
            }

            @Override
            public Response response() {
                return thisExchange.response();
            }

            @Override
            public A context() {
                return thisExchange.context();
            }

            @Override
            public ErrorExchange<A> finalizer(Mono<Void> finalizer) {
                thisExchange.finalizer(finalizer);
                return this;
            }

            @Override
            public Throwable getError() {
                return (Throwable)errorMapper.apply(thisExchange.getError());
            }
        };
    }
}

