/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.RequestHeaders;
import io.inverno.mod.http.server.internal.netty.LinkedHttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Http1xRequestHeaders
implements RequestHeaders {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final LinkedHttpHeaders underlyingHeaders;

    public Http1xRequestHeaders(HttpRequest httpRequest, HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.underlyingHeaders = (LinkedHttpHeaders)httpRequest.headers();
    }

    LinkedHttpHeaders getUnderlyingHeaders() {
        return this.underlyingHeaders;
    }

    @Override
    public String getContentType() {
        return this.underlyingHeaders.get((CharSequence)"content-type");
    }

    @Override
    public Long getContentLength() {
        return this.underlyingHeaders.getLong("content-length");
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.underlyingHeaders.contains(name);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingHeaders.contains(name, value, true);
    }

    @Override
    public Set<String> getNames() {
        return this.underlyingHeaders.names();
    }

    @Override
    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.underlyingHeaders.get(name));
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.underlyingHeaders.getAll(name);
    }

    @Override
    public List<Map.Entry<String, String>> getAll() {
        return this.underlyingHeaders.entries();
    }

    @Override
    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    @Override
    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.underlyingHeaders.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    @Override
    public List<Header> getAllHeader() {
        return this.underlyingHeaders.entries().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    @Override
    public List<Parameter> getAllParameter(CharSequence name) {
        return this.underlyingHeaders.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    @Override
    public List<Parameter> getAllParameter() {
        return this.underlyingHeaders.entries().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }
}

