/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.ErrorExchangeHandler;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeContext;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.RootExchangeHandler;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.GenericErrorExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xConnectionEncoder;
import io.inverno.mod.http.server.internal.http1x.Http1xRequest;
import io.inverno.mod.http.server.internal.http1x.Http1xRequestHeaders;
import io.inverno.mod.http.server.internal.http1x.Http1xResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseTrailers;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.inverno.mod.http.server.internal.netty.FlatFullHttpResponse;
import io.inverno.mod.http.server.internal.netty.FlatHttpResponse;
import io.inverno.mod.http.server.internal.netty.FlatLastHttpContent;
import io.inverno.mod.http.server.internal.netty.LinkedHttpHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;

public class Http1xExchange
extends AbstractExchange {
    private final Http1xConnectionEncoder encoder;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private boolean manageChunked;
    private Charset charset;
    Http1xExchange next;
    boolean keepAlive;
    boolean trailers;

    public Http1xExchange(ChannelHandlerContext context, HttpRequest httpRequest, Http1xConnectionEncoder encoder, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, RootExchangeHandler<ExchangeContext, Exchange<ExchangeContext>> rootHandler, ErrorExchangeHandler<Throwable, ErrorExchange<Throwable>> errorHandler) {
        super(context, rootHandler, errorHandler, new Http1xRequest(context, httpRequest, new Http1xRequestHeaders(httpRequest, headerService, parameterConverter), parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder), new Http1xResponse(context, headerService, parameterConverter));
        this.encoder = encoder;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.keepAlive = !httpRequest.headers().contains("connection", "close", true);
        String te = httpRequest.headers().get("te");
        this.trailers = te != null && te.contains("trailers");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.next != null) {
            this.next.dispose();
        }
    }

    @Override
    protected ErrorExchange<Throwable> createErrorExchange(Throwable error) {
        return new GenericErrorExchange(this.request, new Http1xResponse(this.context, this.headerService, this.parameterConverter), (Mono<Void>)this.finalizer, error, this.exchangeContext);
    }

    private Charset getCharset() {
        if (this.response.isHeadersWritten()) {
            return this.response().headers().getHeader("content-type").map(Headers.ContentType::getCharset).orElse(Charsets.DEFAULT);
        }
        if (this.charset == null) {
            this.charset = this.response().headers().getHeader("content-type").map(Headers.ContentType::getCharset).orElse(Charsets.DEFAULT);
        }
        return this.charset;
    }

    private void preProcessResponseInternals(HttpResponseStatus status, HttpHeaders internalHeaders, HttpHeaders internalTrailers) {
        if (!this.keepAlive) {
            internalHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        }
        if (status == HttpResponseStatus.NOT_MODIFIED) {
            internalHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            internalHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
        if (this.trailers && internalTrailers != null) {
            internalHeaders.set("trailer", (Object)internalTrailers.names().stream().collect(Collectors.joining(", ")));
        }
    }

    private HttpResponse createHttpResponse(Http1xResponseHeaders headers, Http1xResponseTrailers trailers) {
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)headers.getStatusCode());
        LinkedHttpHeaders httpHeaders = headers.getUnderlyingHeaders();
        LinkedHttpHeaders httpTrailers = trailers != null ? trailers.getUnderlyingTrailers() : null;
        this.preProcessResponseInternals(status, httpHeaders, httpTrailers);
        return new FlatHttpResponse(HttpVersion.HTTP_1_1, status, (HttpHeaders)httpHeaders, false);
    }

    private HttpResponse createFullHttpResponse(Http1xResponseHeaders headers, ByteBuf content) {
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)headers.getStatusCode());
        LinkedHttpHeaders httpHeaders = headers.getUnderlyingHeaders();
        this.preProcessResponseInternals(status, httpHeaders, null);
        return new FlatFullHttpResponse(HttpVersion.HTTP_1_1, status, httpHeaders, content, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onNextMany(ByteBuf value) {
        try {
            Http1xResponseHeaders headers = (Http1xResponseHeaders)this.response.headers();
            if (!headers.isWritten()) {
                List<String> transferEncodings = headers.getAll("transfer-encoding");
                if (headers.getContentLength() == null && !transferEncodings.contains("chunked")) {
                    headers.set("transfer-encoding", "chunked");
                    headers.get("content-type").ifPresent(contentType -> {
                        this.manageChunked = contentType.regionMatches(true, 0, "text/event-stream", 0, "text/event-stream".length());
                    });
                }
                this.encoder.writeFrame(this.context, this.createHttpResponse(headers, (Http1xResponseTrailers)this.response.trailers()), this.context.voidPromise());
                headers.setWritten(true);
            }
            if (this.manageChunked) {
                ByteBuf chunked_header = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(value.readableBytes()) + "\r\n"), (Charset)Charsets.orDefault((Charset)this.getCharset())));
                ByteBuf chunked_trailer = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)Charsets.orDefault((Charset)this.getCharset())));
                this.encoder.writeFrame(this.context, new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{chunked_header, value, chunked_trailer})), this.context.voidPromise());
            } else {
                this.encoder.writeFrame(this.context, new DefaultHttpContent(value), this.context.voidPromise());
            }
        }
        finally {
            this.handler.exchangeNext(this.context, value);
        }
    }

    @Override
    protected void onCompleteWithError(Throwable throwable) {
        ChannelPromise finalizePromise = this.context.newPromise();
        this.finalizeExchange(finalizePromise, () -> this.handler.exchangeError(this.context, throwable));
        finalizePromise.tryFailure(throwable);
    }

    @Override
    protected void onCompleteEmpty() {
        Http1xResponse http1xResponse = (Http1xResponse)this.response;
        Http1xResponseHeaders headers = http1xResponse.headers();
        if (this.request.getMethod().equals((Object)Method.HEAD)) {
            if (headers.getContentLength() == null && !headers.contains("transfer-encoding")) {
                headers.set("transfer-encoding", "chunked");
            }
            ChannelPromise finalizePromise = this.context.newPromise();
            this.encoder.writeFrame(this.context, this.createFullHttpResponse(headers, Unpooled.buffer((int)0)), finalizePromise);
            headers.setWritten(true);
            this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
        } else {
            http1xResponse.body().getFileRegionData().ifPresentOrElse(fileRegionData -> {
                this.encoder.writeFrame(this.context, this.createHttpResponse(headers, http1xResponse.trailers()), this.context.voidPromise());
                headers.setWritten(true);
                fileRegionData.subscribe((Subscriber)new FileRegionDataSubscriber());
            }, () -> {
                ChannelPromise finalizePromise = this.context.newPromise();
                this.encoder.writeFrame(this.context, this.createFullHttpResponse(headers, Unpooled.buffer((int)0)), finalizePromise);
                headers.setWritten(true);
                this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
            });
        }
    }

    @Override
    protected void onCompleteSingle(ByteBuf value) {
        Http1xResponseHeaders headers = (Http1xResponseHeaders)this.response.headers();
        ChannelPromise finalizePromise = this.context.newPromise();
        this.encoder.writeFrame(this.context, this.createFullHttpResponse(headers, value), finalizePromise);
        headers.setWritten(true);
        this.handler.exchangeNext(this.context, value);
        this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
    }

    @Override
    protected void onCompleteMany() {
        Http1xResponseTrailers trailers = (Http1xResponseTrailers)this.response.trailers();
        LastHttpContent msg = trailers != null ? new FlatLastHttpContent(Unpooled.EMPTY_BUFFER, trailers.getUnderlyingTrailers()) : LastHttpContent.EMPTY_LAST_CONTENT;
        ChannelPromise finalizePromise = this.context.newPromise();
        this.encoder.writeFrame(this.context, msg, finalizePromise);
        this.finalizeExchange(finalizePromise, () -> this.handler.exchangeComplete(this.context));
    }

    private class FileRegionDataSubscriber
    extends BaseSubscriber<FileRegion> {
        private FileRegionDataSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            this.request(1L);
        }

        protected void hookOnNext(FileRegion fileRegion) {
            Http1xExchange.this.executeInEventLoop(() -> {
                Http1xExchange.this.transferedLength = (int)((long)Http1xExchange.this.transferedLength + fileRegion.count());
                Http1xExchange.this.encoder.writeFrame(Http1xExchange.this.context, fileRegion, Http1xExchange.this.context.newPromise().addListener(future -> {
                    if (future.isSuccess()) {
                        Http1xExchange.this.handler.exchangeNext(Http1xExchange.this.context, null);
                        this.request(1L);
                    } else {
                        Http1xExchange.this.handler.exchangeError(Http1xExchange.this.context, future.cause());
                        this.cancel();
                        Http1xExchange.this.onCompleteWithError(future.cause());
                    }
                }));
            });
        }

        protected void hookOnComplete() {
            Http1xExchange.this.executeInEventLoop(() -> {
                Http1xResponseTrailers trailers = (Http1xResponseTrailers)Http1xExchange.this.response.trailers();
                LastHttpContent msg = trailers != null ? new FlatLastHttpContent(Unpooled.EMPTY_BUFFER, trailers.getUnderlyingTrailers()) : LastHttpContent.EMPTY_LAST_CONTENT;
                ChannelPromise finalizePromise = Http1xExchange.this.context.newPromise();
                Http1xExchange.this.encoder.writeFrame(Http1xExchange.this.context, msg, finalizePromise);
                Http1xExchange.this.finalizeExchange(finalizePromise, () -> Http1xExchange.this.handler.exchangeComplete(Http1xExchange.this.context));
            });
        }
    }
}

