/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Destroy;
import io.inverno.core.annotation.Init;
import io.inverno.mod.base.net.NetService;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class HttpServer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private NetService netService;
    private HttpServerConfiguration configuration;
    private ChannelInitializer<SocketChannel> channelInitializer;
    private ChannelFuture serverChannelFuture;

    public HttpServer(HttpServerConfiguration configuration, NetService netService, ChannelInitializer<SocketChannel> channelInitializer) {
        this.configuration = configuration;
        this.netService = netService;
        this.channelInitializer = channelInitializer;
    }

    @Init
    public void start() throws CertificateException, InterruptedException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String scheme;
        InetSocketAddress serverAddress = new InetSocketAddress(this.configuration.server_host(), this.configuration.server_port());
        ServerBootstrap serverBootstrap = this.configuration.server_event_loop_group_size() != null ? this.netService.createServer((SocketAddress)serverAddress, this.configuration.server_event_loop_group_size().intValue()) : this.netService.createServer((SocketAddress)serverAddress);
        this.serverChannelFuture = serverBootstrap.childHandler(this.channelInitializer).bind((SocketAddress)serverAddress).sync();
        String string = scheme = this.configuration.tls_enabled() ? "https://" : "http://";
        if (!this.serverChannelFuture.isSuccess()) {
            throw new RuntimeException("Can't start Web server on " + scheme + serverAddress.getHostString() + ":" + serverAddress.getPort(), this.serverChannelFuture.cause());
        }
        this.logger.info(() -> "HTTP Server (" + this.netService.getTransportType().toString().toLowerCase() + ") listening on " + scheme + serverAddress.getHostString() + ":" + serverAddress.getPort());
    }

    @Destroy
    public void stop() throws InterruptedException {
        this.serverChannelFuture.channel().close();
    }
}

