/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.base.MethodNotAllowedException;
import io.inverno.mod.http.base.ServiceUnavailableException;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.ErrorExchangeHandler;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;

public class GenericErrorHandler
implements ErrorExchangeHandler<Throwable, ErrorExchange<Throwable>> {
    @Override
    public void handle(ErrorExchange<Throwable> exchange) throws HttpException {
        if (exchange.response().isHeadersWritten()) {
            throw new IllegalStateException("Headers already written", exchange.getError());
        }
        if (exchange.getError() instanceof HttpException) {
            HttpException webError = (HttpException)exchange.getError();
            if (webError instanceof MethodNotAllowedException) {
                exchange.response().headers(headers -> headers.add("allow", ((MethodNotAllowedException)webError).getAllowedMethods().stream().map(Enum::toString).collect(Collectors.joining(", "))));
            } else if (exchange.getError() instanceof ServiceUnavailableException) {
                ((ServiceUnavailableException)webError).getRetryAfter().ifPresent(retryAfter -> exchange.response().headers(headers -> headers.add("retry-after", retryAfter.format(DateTimeFormatter.RFC_1123_DATE_TIME))));
            }
            exchange.response().headers(h -> h.status(webError.getStatusCode())).body().empty();
        } else {
            exchange.response().headers(h -> h.status(Status.INTERNAL_SERVER_ERROR)).body().empty();
        }
    }
}

