package io.inverno.mod.http.server;

import io.inverno.core.v1.Module;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.NetService;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.http.base.Base;
import io.inverno.mod.http.base.header.HeaderCodec;
import io.inverno.mod.http.server.internal.ErrorHandler;
import io.inverno.mod.http.server.internal.HttpChannelConfigurer;
import io.inverno.mod.http.server.internal.HttpChannelInitializer;
import io.inverno.mod.http.server.internal.HttpServer;
import io.inverno.mod.http.server.internal.ParameterConverter;
import io.inverno.mod.http.server.internal.RootHandler;
import io.inverno.mod.http.server.internal.SslCipherSuiteFilter;
import io.inverno.mod.http.server.internal.SslContextWrapper;
import io.inverno.mod.http.server.internal.http1x.Http1xChannelHandlerFactory;
import io.inverno.mod.http.server.internal.http2.Http2ChannelHandlerFactory;
import io.inverno.mod.http.server.internal.multipart.MultipartFormDataBodyDecoder;
import io.inverno.mod.http.server.internal.multipart.UrlEncodedBodyDecoder;
import io.netty.handler.ssl.SslContext;
import java.lang.String;
import java.lang.Throwable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;

@Generated(value= {"io.inverno.core.compiler.InvernoCompiler", "1"}, date = "2022-02-24T16:19:37.226616496+01:00[Europe/Paris]")
public final class Server extends Module {

	private Base base;

	private Bean<ErrorExchangeHandler<Throwable, ErrorExchange<Throwable>>> errorHandler;
	private Bean<Http1xChannelHandlerFactory> http1xChannelHandlerFactory;
	private Bean<Http2ChannelHandlerFactory> http2ChannelHandlerFactory;
	private Bean<HttpChannelConfigurer> httpChannelConfigurer;
	private Bean<HttpChannelInitializer> httpChannelInitializer;
	private Bean<HttpServer> httpServer;
	private Bean<HttpServerConfiguration> httpServerConfiguration;
	private Bean<MultipartFormDataBodyDecoder> multipartFormDataBodyDecoder;
	private Bean<ObjectConverter<String>> parameterConverter;
	private Bean<RootExchangeHandler<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>>> rootHandler;
	private Bean<SslCipherSuiteFilter> sslCipherSuiteFilter;
	private Bean<SslContext> sslContextWrapper;
	private Bean<UrlEncodedBodyDecoder> urlEncodedBodyDecoder;

	private Server(
			@Socket(name = "headerCodecs", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs,
			@Socket(name = "netService", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Supplier<NetService> netService,
			@Socket(name = "resourceService", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Supplier<ResourceService> resourceService,
			@Socket(name = "errorHandler", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<ErrorExchangeHandler<Throwable, ErrorExchange<Throwable>>>> errorHandlerOverride,
			@Socket(name = "httpServerConfiguration", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<HttpServerConfiguration>> httpServerConfigurationOverride,
			@Socket(name = "parameterConverter", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<ObjectConverter<String>>> parameterConverterOverride,
			@Socket(name = "rootHandler", wiredTo = {"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<RootExchangeHandler<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>>>> rootHandlerOverride
		) {
		super("io.inverno.mod.http.server");

		this.base = this.with(new Base.Linker(Map.ofEntries(
			Map.entry("headerCodecs", Optional.of((Supplier<List<HeaderCodec<?>>>)() -> new BeanAggregator<HeaderCodec<?>>()
					.add(headerCodecs.orElse(() -> null).get())
				.toList())),
			Map.entry("parameterConverter", Optional.of((Supplier<ObjectConverter<String>>)() -> this.parameterConverter.get()))
		)));

		this.errorHandler = this.with(WrapperBeanBuilder
			.singleton("errorHandler", () -> {
				ErrorHandler errorHandler = new ErrorHandler();

				return errorHandler;
			})
			.override(errorHandlerOverride)
		);
		this.http1xChannelHandlerFactory = this.with(ModuleBeanBuilder
			.singleton("http1xChannelHandlerFactory", () -> {
				Http1xChannelHandlerFactory http1xChannelHandlerFactory = new Http1xChannelHandlerFactory(
					this.rootHandler.get(),
					this.errorHandler.get(),
					this.base.headerService(),
					this.parameterConverter.get(),
					this.urlEncodedBodyDecoder.get(),
					this.multipartFormDataBodyDecoder.get()
				);

				return http1xChannelHandlerFactory;
			})
		);
		this.http2ChannelHandlerFactory = this.with(ModuleBeanBuilder
			.singleton("http2ChannelHandlerFactory", () -> {
				Http2ChannelHandlerFactory http2ChannelHandlerFactory = new Http2ChannelHandlerFactory(
					this.httpServerConfiguration.get(),
					this.rootHandler.get(),
					this.errorHandler.get(),
					this.base.headerService(),
					this.parameterConverter.get(),
					this.urlEncodedBodyDecoder.get(),
					this.multipartFormDataBodyDecoder.get()
				);

				return http2ChannelHandlerFactory;
			})
		);
		this.httpChannelConfigurer = this.with(ModuleBeanBuilder
			.singleton("httpChannelConfigurer", () -> {
				HttpChannelConfigurer httpChannelConfigurer = new HttpChannelConfigurer(
					this.httpServerConfiguration.get(),
					netService.get(),
					() -> this.sslContextWrapper.get(),
					this.http1xChannelHandlerFactory.get(),
					this.http2ChannelHandlerFactory.get()
				);

				return httpChannelConfigurer;
			})
		);
		this.httpChannelInitializer = this.with(ModuleBeanBuilder
			.singleton("httpChannelInitializer", () -> {
				HttpChannelInitializer httpChannelInitializer = new HttpChannelInitializer(
					this.httpChannelConfigurer.get()
				);

				return httpChannelInitializer;
			})
		);
		this.httpServer = this.with(ModuleBeanBuilder
			.singleton("httpServer", () -> {
				HttpServer httpServer = new HttpServer(
					this.httpServerConfiguration.get(),
					netService.get(),
					this.httpChannelInitializer.get()
				);

				return httpServer;
			})
			.init(HttpServer::start)
			.destroy(HttpServer::stop)
		);
		this.httpServerConfiguration = this.with(WrapperBeanBuilder
			.singleton("httpServerConfiguration", () -> {
				io.inverno.mod.http.server.HttpServerConfigurationLoader.Bean httpServerConfiguration = new io.inverno.mod.http.server.HttpServerConfigurationLoader.Bean();

				return httpServerConfiguration;
			})
			.override(httpServerConfigurationOverride)
		);
		this.multipartFormDataBodyDecoder = this.with(ModuleBeanBuilder
			.singleton("multipartFormDataBodyDecoder", () -> {
				MultipartFormDataBodyDecoder multipartFormDataBodyDecoder = new MultipartFormDataBodyDecoder(
					this.base.headerService(),
					this.parameterConverter.get()
				);

				return multipartFormDataBodyDecoder;
			})
		);
		this.parameterConverter = this.with(WrapperBeanBuilder
			.singleton("parameterConverter", () -> {
				ParameterConverter parameterConverter = new ParameterConverter();

				return parameterConverter;
			})
			.override(parameterConverterOverride)
		);
		this.rootHandler = this.with(WrapperBeanBuilder
			.singleton("rootHandler", () -> {
				RootHandler rootHandler = new RootHandler();

				return rootHandler;
			})
			.override(rootHandlerOverride)
		);
		this.sslCipherSuiteFilter = this.with(ModuleBeanBuilder
			.singleton("sslCipherSuiteFilter", () -> {
				SslCipherSuiteFilter sslCipherSuiteFilter = new SslCipherSuiteFilter(
					this.httpServerConfiguration.get()
				);

				return sslCipherSuiteFilter;
			})
		);
		this.sslContextWrapper = this.with(WrapperBeanBuilder
			.prototype("sslContextWrapper", () -> {
				SslContextWrapper sslContextWrapper = new SslContextWrapper(
					this.httpServerConfiguration.get(),
					resourceService.get()
				);
				Optional.of(this.sslCipherSuiteFilter.get()).ifPresent(sslContextWrapper::setCipherSuiteFilter);
				return sslContextWrapper;
			})
			.init(SslContextWrapper::init)
		);
		this.urlEncodedBodyDecoder = this.with(ModuleBeanBuilder
			.singleton("urlEncodedBodyDecoder", () -> {
				UrlEncodedBodyDecoder urlEncodedBodyDecoder = new UrlEncodedBodyDecoder(
					this.parameterConverter.get()
				);

				return urlEncodedBodyDecoder;
			})
		);
	}

	public ErrorExchangeHandler<Throwable, ErrorExchange<Throwable>> errorHandler() {
		return this.errorHandler.get();
	}

	private Http1xChannelHandlerFactory http1xChannelHandlerFactory() {
		return this.http1xChannelHandlerFactory.get();
	}

	private Http2ChannelHandlerFactory http2ChannelHandlerFactory() {
		return this.http2ChannelHandlerFactory.get();
	}

	private HttpChannelConfigurer httpChannelConfigurer() {
		return this.httpChannelConfigurer.get();
	}

	private HttpChannelInitializer httpChannelInitializer() {
		return this.httpChannelInitializer.get();
	}

	private HttpServer httpServer() {
		return this.httpServer.get();
	}

	public HttpServerConfiguration httpServerConfiguration() {
		return this.httpServerConfiguration.get();
	}

	private MultipartFormDataBodyDecoder multipartFormDataBodyDecoder() {
		return this.multipartFormDataBodyDecoder.get();
	}

	private ObjectConverter<String> parameterConverter() {
		return this.parameterConverter.get();
	}

	public RootExchangeHandler<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>> rootHandler() {
		return this.rootHandler.get();
	}

	private SslCipherSuiteFilter sslCipherSuiteFilter() {
		return this.sslCipherSuiteFilter.get();
	}

	private SslContext sslContextWrapper() {
		return this.sslContextWrapper.get();
	}

	private UrlEncodedBodyDecoder urlEncodedBodyDecoder() {
		return this.urlEncodedBodyDecoder.get();
	}

	public static final class Builder extends ModuleBuilder<Server> {

		private Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs = Optional.empty();
		private Supplier<NetService> netService;
		private Supplier<ResourceService> resourceService;
		private Optional<Supplier<ErrorExchangeHandler<Throwable, ErrorExchange<Throwable>>>> errorHandler = Optional.empty();
		private Optional<Supplier<HttpServerConfiguration>> httpServerConfiguration = Optional.empty();
		private Optional<Supplier<ObjectConverter<String>>> parameterConverter = Optional.empty();
		private Optional<Supplier<RootExchangeHandler<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>>>> rootHandler = Optional.empty();

		public Builder(NetService netService, ResourceService resourceService) {
			super("netService", netService, "resourceService", resourceService);

			this.netService = () -> netService;
			this.resourceService = () -> resourceService;
		}

		protected Server doBuild() {
			return new Server(this.headerCodecs, this.netService, this.resourceService, this.errorHandler, this.httpServerConfiguration, this.parameterConverter, this.rootHandler);
		}

		public Builder setHeaderCodecs(List<HeaderCodec<?>> headerCodecs) {
			this.headerCodecs = Optional.ofNullable(headerCodecs != null ? () -> headerCodecs : null);
			return this;
		}

		public Builder setErrorHandler(ErrorExchangeHandler<Throwable, ErrorExchange<Throwable>> errorHandler) {
			this.errorHandler = Optional.ofNullable(errorHandler != null ? () -> errorHandler : null);
			return this;
		}

		public Builder setHttpServerConfiguration(HttpServerConfiguration httpServerConfiguration) {
			this.httpServerConfiguration = Optional.ofNullable(httpServerConfiguration != null ? () -> httpServerConfiguration : null);
			return this;
		}

		public Builder setParameterConverter(ObjectConverter<String> parameterConverter) {
			this.parameterConverter = Optional.ofNullable(parameterConverter != null ? () -> parameterConverter : null);
			return this;
		}

		public Builder setRootHandler(RootExchangeHandler<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>> rootHandler) {
			this.rootHandler = Optional.ofNullable(rootHandler != null ? () -> rootHandler : null);
			return this;
		}
	}

	public static final class Linker extends ModuleLinker<Server> {

		public Linker(Map<String, Object> sockets) {
			super(sockets);
		}

		@SuppressWarnings("unchecked")
		protected Server link() {
			return new Server(
				(Optional<Supplier<List<HeaderCodec<?>>>>)this.sockets.get("headerCodecs"),
				(Supplier<NetService>)this.sockets.get("netService"),
				(Supplier<ResourceService>)this.sockets.get("resourceService"),
				(Optional<Supplier<ErrorExchangeHandler<Throwable, ErrorExchange<Throwable>>>>)this.sockets.get("errorHandler"),
				(Optional<Supplier<HttpServerConfiguration>>)this.sockets.get("httpServerConfiguration"),
				(Optional<Supplier<ObjectConverter<String>>>)this.sockets.get("parameterConverter"),
				(Optional<Supplier<RootExchangeHandler<? extends ExchangeContext, ? extends Exchange<? extends ExchangeContext>>>>)this.sockets.get("rootHandler")
			);
		}
	}
}
