/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class LinkedHttpHeaders
extends HttpHeaders {
    private HeaderNode head;
    private HeaderNode tail;
    private HeaderNode[] buckets = new HeaderNode[16];
    private static final int COLON_AND_SPACE_SHORT = 14880;
    static final int CRLF_SHORT = 3338;

    public LinkedHttpHeaders() {
        this.head = this.tail = new HeaderNode();
    }

    private CharSequence convertToCharSequence(Object value) {
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        if (value instanceof TemporalAccessor) {
            return DateTimeFormatter.RFC_1123_DATE_TIME.format((TemporalAccessor)value);
        }
        if (value instanceof Date) {
            return DateTimeFormatter.RFC_1123_DATE_TIME.format(((Date)value).toInstant());
        }
        if (value instanceof Calendar) {
            return DateTimeFormatter.RFC_1123_DATE_TIME.format(((Calendar)value).toInstant());
        }
        return value.toString();
    }

    private CharSequence get0(CharSequence name) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        HeaderNode current = this.buckets[bucketIndex];
        CharSequence value = null;
        while (current != null) {
            CharSequence key = current.key;
            if (current.hashCode == hashCode && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                value = current.getValue();
            }
            current = current.bucketNext;
        }
        return value;
    }

    public String get(String name) {
        return this.get((CharSequence)name);
    }

    public String get(CharSequence name) {
        CharSequence ret = this.get0(name);
        return ret != null ? ret.toString() : null;
    }

    public List<String> getAll(String name) {
        return this.getAll((CharSequence)name);
    }

    public List<String> getAll(CharSequence name) {
        LinkedList<String> values = new LinkedList<String>();
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        HeaderNode e = this.buckets[i];
        while (e != null) {
            CharSequence key = e.key;
            if (e.hashCode == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                values.addFirst(e.getValue().toString());
            }
            e = e.bucketNext;
        }
        return values;
    }

    public List<CharSequence> getAllCharSequence(CharSequence name) {
        LinkedList<CharSequence> values = new LinkedList<CharSequence>();
        int h = AsciiString.hashCode((CharSequence)name);
        int i = h & 0xF;
        HeaderNode e = this.buckets[i];
        while (e != null) {
            CharSequence key = e.key;
            if (e.hashCode == h && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                values.addFirst(e.getValue());
            }
            e = e.bucketNext;
        }
        return values;
    }

    public CharSequence getCharSequence(CharSequence name) {
        return this.get0(name);
    }

    public Integer getInt(CharSequence name) {
        String value = this.get(name);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    public int getInt(CharSequence name, int defaultValue) {
        Objects.requireNonNull(name);
        String value = this.get(name);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public Long getLong(CharSequence name) {
        String value = this.get(name);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    public long getLong(CharSequence name, long defaultValue) {
        Objects.requireNonNull(name);
        String value = this.get(name);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    public Short getShort(CharSequence name) {
        String value = this.get(name);
        return value != null ? Short.valueOf(Short.parseShort(value)) : null;
    }

    public short getShort(CharSequence name, short defaultValue) {
        Objects.requireNonNull(name);
        String value = this.get(name);
        return value != null ? Short.parseShort(value) : defaultValue;
    }

    public Long getTimeMillis(CharSequence name) {
        String value = this.get(name);
        return value != null ? Long.valueOf(DateTimeFormatter.RFC_1123_DATE_TIME.parse(value).getLong(ChronoField.MILLI_OF_SECOND)) : null;
    }

    public long getTimeMillis(CharSequence name, long defaultValue) {
        String value = this.get(name);
        return value != null ? DateTimeFormatter.RFC_1123_DATE_TIME.parse(value).getLong(ChronoField.MILLI_OF_SECOND) : defaultValue;
    }

    private void add0(CharSequence name, CharSequence value) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        this.add0(name, value, hashCode, bucketIndex);
    }

    private void add0(CharSequence name, CharSequence value, int hashCode, int bucketIndex) {
        HeaderNode newNode;
        HeaderNode bucketHead = this.buckets[bucketIndex];
        this.buckets[bucketIndex] = newNode = new HeaderNode(hashCode, name, value);
        newNode.bucketNext = bucketHead;
        HeaderNode head = this.head;
        this.head = newNode;
        head.previous = newNode;
        newNode.next = head;
    }

    public HttpHeaders add(String name, Object value) {
        return this.add((CharSequence)name, value);
    }

    public HttpHeaders add(CharSequence name, Object value) {
        if (value instanceof Iterable) {
            this.add(name, (Iterable)value);
        } else {
            this.add0(name, this.convertToCharSequence(value));
        }
        return this;
    }

    public HttpHeaders add(String name, Iterable<?> values) {
        return this.add((CharSequence)name, values);
    }

    public HttpHeaders add(CharSequence name, Iterable<?> values) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        for (Object value : values) {
            this.add0(name, this.convertToCharSequence(value), hashCode, bucketIndex);
        }
        return this;
    }

    public HttpHeaders addCharSequence(CharSequence name, CharSequence value) {
        this.add0(name, value);
        return this;
    }

    public HttpHeaders addCharSequence(CharSequence name, Iterable<CharSequence> values) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        for (CharSequence value : values) {
            this.add0(name, value, hashCode, bucketIndex);
        }
        return this;
    }

    public HttpHeaders addInt(CharSequence name, int value) {
        this.add0(name, Integer.toString(value));
        return this;
    }

    public HttpHeaders addLong(CharSequence name, long value) {
        this.add0(name, Long.toString(value));
        return this;
    }

    public HttpHeaders addShort(CharSequence name, short value) {
        this.add0(name, Short.toString(value));
        return this;
    }

    private LinkedHttpHeaders set0(CharSequence name, CharSequence value) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        return this.set0(name, value, hashCode, bucketIndex);
    }

    private LinkedHttpHeaders set0(CharSequence name, CharSequence value, int hashCode, int bucketIndex) {
        this.remove0(name, hashCode, bucketIndex);
        if (value != null) {
            this.add0(name, value, hashCode, bucketIndex);
        }
        return this;
    }

    public HttpHeaders set(String name, Object value) {
        return this.set((CharSequence)name, value);
    }

    public HttpHeaders set(CharSequence name, Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Iterable) {
            this.set(name, (Iterable)value);
        } else {
            this.set0(name, this.convertToCharSequence(value));
        }
        return this;
    }

    public HttpHeaders set(String name, Iterable<?> values) {
        return this.set((CharSequence)name, values);
    }

    public HttpHeaders set(CharSequence name, Iterable<?> values) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        for (Object value : values) {
            this.set0(name, this.convertToCharSequence(value), hashCode, bucketIndex);
        }
        return this;
    }

    public LinkedHttpHeaders setCharSequence(CharSequence name, CharSequence value) {
        this.set0(name, value);
        return this;
    }

    public HttpHeaders setCharSequence(CharSequence name, Iterable<CharSequence> values) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        for (CharSequence value : values) {
            this.set0(name, value, hashCode, bucketIndex);
        }
        return this;
    }

    public HttpHeaders setInt(CharSequence name, int value) {
        this.set0(name, Integer.toString(value));
        return this;
    }

    public HttpHeaders setLong(CharSequence name, long value) {
        this.set0(name, Long.toString(value));
        return this;
    }

    public HttpHeaders setShort(CharSequence name, short value) {
        this.set0(name, Short.toString(value));
        return this;
    }

    private void remove0(CharSequence name) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        this.remove0(name, hashCode, bucketIndex);
    }

    private void remove0(CharSequence name, int hashCode, int bucketIndex) {
        HeaderNode current = this.buckets[bucketIndex];
        HeaderNode previous = null;
        while (current != null) {
            CharSequence key = current.key;
            if (current.hashCode == hashCode && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                if (previous == null) {
                    this.buckets[bucketIndex] = current.bucketNext;
                } else {
                    previous.bucketNext = current.bucketNext;
                }
                if (current.previous == null) {
                    current.next.previous = null;
                    this.head = current.next;
                } else {
                    current.previous.next = current.next;
                    current.next.previous = current.previous;
                }
            } else {
                previous = current;
            }
            current = current.bucketNext;
        }
    }

    public HttpHeaders remove(String name) {
        return this.remove((CharSequence)name);
    }

    public HttpHeaders remove(CharSequence name) {
        this.remove0(name);
        return this;
    }

    public HttpHeaders clear() {
        Arrays.fill(this.buckets, null);
        this.tail.previous = null;
        this.head = this.tail;
        return this;
    }

    public List<Map.Entry<String, String>> entries() {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>();
        this.forEach(entries::add);
        return entries;
    }

    public List<Map.Entry<CharSequence, CharSequence>> entriesCharSequence() {
        ArrayList<Map.Entry<CharSequence, CharSequence>> entries = new ArrayList<Map.Entry<CharSequence, CharSequence>>();
        Iterator<Map.Entry<CharSequence, CharSequence>> entriesIterator = this.iteratorCharSequence();
        while (entriesIterator.hasNext()) {
            entries.add(entriesIterator.next());
        }
        return entries;
    }

    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        HeaderNode current = this.head;
        while (current.next != null) {
            names.add(current.getKey().toString());
            current = current.next;
        }
        return names;
    }

    private boolean contains0(CharSequence name, CharSequence value, boolean ignoreCase) {
        int hashCode = AsciiString.hashCode((CharSequence)name);
        int bucketIndex = hashCode & 0xF;
        HeaderNode current = this.buckets[bucketIndex];
        while (current != null) {
            CharSequence key = current.key;
            if (current.hashCode == hashCode && (name == key || AsciiString.contentEqualsIgnoreCase((CharSequence)name, (CharSequence)key))) {
                CharSequence currentValue = current.getValue();
                return currentValue == value || ignoreCase && AsciiString.contentEqualsIgnoreCase((CharSequence)currentValue, (CharSequence)value) || AsciiString.contentEquals((CharSequence)currentValue, (CharSequence)value);
            }
            current = current.bucketNext;
        }
        return false;
    }

    public boolean contains(String name) {
        return this.get0(name) != null;
    }

    public boolean contains(CharSequence name) {
        return this.get0(name) != null;
    }

    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.contains0(name, value, ignoreCase);
    }

    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.contains0(name, value, ignoreCase);
    }

    public boolean isEmpty() {
        return this.head.next == null;
    }

    public int size() {
        int size = 0;
        HeaderNode current = this.head;
        while (current != null) {
            ++size;
        }
        return size;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return new Iterator<Map.Entry<String, String>>(){
            HeaderNode current;
            {
                this.current = LinkedHttpHeaders.this.tail;
            }

            @Override
            public boolean hasNext() {
                return this.current.previous != null;
            }

            @Override
            public Map.Entry<String, String> next() {
                HeaderNode next = this.current.previous;
                if (next == null) {
                    throw new NoSuchElementException();
                }
                this.current = next;
                return Map.entry(next.key.toString(), next.value.toString());
            }
        };
    }

    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            HeaderNode current;
            {
                this.current = LinkedHttpHeaders.this.tail;
            }

            @Override
            public boolean hasNext() {
                return this.current.previous != null;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                HeaderNode next = this.current.previous;
                if (next == null) {
                    throw new NoSuchElementException();
                }
                this.current = next;
                return next;
            }
        };
    }

    public void encode(ByteBuf buf) {
        HeaderNode current = this.tail.previous;
        while (current != null) {
            LinkedHttpHeaders.encoderHeader(current.key, current.value, buf);
            current = current.previous;
        }
    }

    static void encoderHeader(CharSequence name, CharSequence value, ByteBuf buf) {
        int nameLen = name.length();
        int valueLen = value.length();
        int headerLen = nameLen + valueLen + 4;
        buf.ensureWritable(headerLen);
        int offset = buf.writerIndex();
        LinkedHttpHeaders.writeAscii(buf, offset, name);
        ByteBufUtil.setShortBE((ByteBuf)buf, (int)(offset += nameLen), (int)14880);
        LinkedHttpHeaders.writeAscii(buf, offset += 2, value);
        ByteBufUtil.setShortBE((ByteBuf)buf, (int)(offset += valueLen), (int)3338);
        buf.writerIndex(offset += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)((AsciiString)value), (int)0, (ByteBuf)buf, (int)offset, (int)value.length());
        } else {
            buf.setCharSequence(offset, value, StandardCharsets.US_ASCII);
        }
    }

    private final class HeaderNode
    implements Map.Entry<CharSequence, CharSequence> {
        final CharSequence key;
        final int hashCode;
        CharSequence value;
        HeaderNode next;
        HeaderNode previous;
        HeaderNode bucketNext;

        private HeaderNode() {
            this.hashCode = -1;
            this.key = null;
            this.value = null;
        }

        private HeaderNode(int hashCode, CharSequence key, CharSequence value) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            CharSequence previousValue = this.value;
            this.value = value;
            return previousValue;
        }
    }
}

