/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;

public class FlatLastHttpContent
extends DefaultByteBufHolder
implements LastHttpContent {
    private final HttpHeaders trailingHeaders;
    private DecoderResult result;

    public FlatLastHttpContent(ByteBuf content, HttpHeaders trailingHeaders) {
        this(content, trailingHeaders, DecoderResult.SUCCESS);
    }

    public FlatLastHttpContent(ByteBuf content, HttpHeaders trailingHeaders, DecoderResult result) {
        super(content);
        this.trailingHeaders = trailingHeaders;
        this.result = result;
    }

    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public LastHttpContent copy() {
        return this.replace(this.content().copy());
    }

    public LastHttpContent duplicate() {
        return this.replace(this.content().duplicate());
    }

    public LastHttpContent retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    public LastHttpContent replace(ByteBuf content) {
        return new FlatLastHttpContent(content, this.trailingHeaders, this.result);
    }

    public LastHttpContent retain(int increment) {
        super.retain(increment);
        return this;
    }

    public LastHttpContent retain() {
        super.retain();
        return this;
    }

    public DecoderResult decoderResult() {
        return this.result;
    }

    public DecoderResult getDecoderResult() {
        return this.result;
    }

    public void setDecoderResult(DecoderResult result) {
        this.result = result;
    }

    public FlatLastHttpContent touch() {
        super.touch();
        return this;
    }

    public FlatLastHttpContent touch(Object hint) {
        super.touch(hint);
        return this;
    }
}

