/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.RequestBody;
import io.inverno.mod.http.server.RequestData;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class GenericRequestBody
implements RequestBody {
    private Flux<ByteBuf> data;
    private Optional<Headers.ContentType> contentType;
    private RequestData<ByteBuf> rawData;
    private RequestBody.UrlEncoded urlEncodedData;
    private RequestBody.Multipart<Part> multipartData;
    private MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private MultipartDecoder<Part> multipartBodyDecoder;

    public GenericRequestBody(Optional<Headers.ContentType> contentType, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, Flux<ByteBuf> data) {
        this.contentType = contentType;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.data = data;
    }

    @Override
    public RequestData<ByteBuf> raw() {
        if (this.rawData == null) {
            this.rawData = new GenericRequestBodyRawData();
        }
        return this.rawData;
    }

    public RequestBody.Multipart<Part> multipart() {
        if (this.multipartData == null) {
            this.multipartData = new GenericRequestBodyMultipartData((Publisher<Part>)this.multipartBodyDecoder.decode(this.data, this.contentType.orElse(null)));
        }
        return this.multipartData;
    }

    @Override
    public RequestBody.UrlEncoded urlEncoded() {
        if (this.urlEncodedData == null) {
            this.urlEncodedData = new GenericRequestBodyUrlEncodedData((Publisher<Parameter>)this.urlEncodedBodyDecoder.decode(this.data, this.contentType.orElse(null)));
        }
        return this.urlEncodedData;
    }

    private class GenericRequestBodyRawData
    implements RequestData<ByteBuf> {
        private GenericRequestBodyRawData() {
        }

        @Override
        public Publisher<ByteBuf> stream() {
            return GenericRequestBody.this.data;
        }
    }

    private class GenericRequestBodyMultipartData
    implements RequestBody.Multipart<Part> {
        private Publisher<Part> parts;

        public GenericRequestBodyMultipartData(Publisher<Part> parts) {
            this.parts = parts;
        }

        @Override
        public Publisher<Part> stream() {
            return this.parts;
        }
    }

    private class GenericRequestBodyUrlEncodedData
    implements RequestBody.UrlEncoded {
        private Publisher<Parameter> parameters;

        public GenericRequestBodyUrlEncodedData(Publisher<Parameter> parameters) {
            this.parameters = parameters;
        }

        @Override
        public Publisher<Parameter> stream() {
            return this.parameters;
        }
    }
}

