/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.multipart;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.PartHeaders;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class GenericPartHeaders
implements PartHeaders {
    private final ObjectConverter<String> parameterConverter;
    private Map<String, List<? extends Header>> headers;

    public GenericPartHeaders(Map<String, List<Header>> headers, ObjectConverter<String> parameterConverter) {
        this.parameterConverter = parameterConverter;
        this.headers = headers != null ? Collections.unmodifiableMap(headers) : Map.of();
    }

    @Override
    public String getContentType() {
        return Optional.ofNullable(this.headers.get("content-type")).filter(l -> !l.isEmpty()).map(l -> ((Header)l.get(0)).getHeaderValue()).orElse(null);
    }

    @Override
    public Long getContentLength() {
        return Optional.ofNullable(this.headers.get("content-length")).filter(l -> !l.isEmpty()).map(l -> ((Header)l.get(0)).getHeaderValue()).map(Long::parseLong).orElse(null);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.containsKey(name);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value) {
        List<? extends Header> headers = this.headers.get(name);
        if (headers != null) {
            for (Header header : headers) {
                if (!header.getHeaderValue().equalsIgnoreCase(value.toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<String> getNames() {
        return this.headers.keySet();
    }

    @Override
    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.headers.get(name)).map(headers -> {
            if (!headers.isEmpty()) {
                return ((Header)headers.get(0)).getHeaderValue();
            }
            return null;
        });
    }

    @Override
    public List<String> getAll(CharSequence name) {
        List<? extends Header> headers = this.headers.get(name);
        if (headers != null) {
            return headers.stream().map(h -> h.getHeaderValue()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<String, String>> getAll() {
        return this.headers.values().stream().flatMap(l -> l.stream().map(h -> Map.entry(h.getHeaderName(), h.getHeaderValue()))).collect(Collectors.toList());
    }

    @Override
    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return Optional.ofNullable(this.headers.get(name)).map(headers -> {
            if (!headers.isEmpty()) {
                return (Header)headers.get(0);
            }
            return null;
        });
    }

    @Override
    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        List<? extends Header> headers = this.headers.get(name);
        if (headers != null) {
            return headers.stream().map(header -> header).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<Header> getAllHeader() {
        return this.headers.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    @Override
    public Optional<Parameter> getParameter(CharSequence name) {
        return Optional.ofNullable(this.headers.get(name)).map(headers -> {
            if (!headers.isEmpty()) {
                return new GenericParameter(((Header)headers.get(0)).getHeaderName(), ((Header)headers.get(0)).getHeaderValue(), this.parameterConverter);
            }
            return null;
        });
    }

    @Override
    public List<Parameter> getAllParameter(CharSequence name) {
        List<? extends Header> headers = this.headers.get(name);
        if (headers != null) {
            return headers.stream().map(h -> new GenericParameter(h.getHeaderName(), h.getHeaderValue(), this.parameterConverter)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<Parameter> getAllParameter() {
        return this.headers.values().stream().flatMap(l -> l.stream().map(h -> new GenericParameter(h.getHeaderName(), h.getHeaderValue(), this.parameterConverter))).collect(Collectors.toList());
    }
}

