/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.http2.Http2ContentEncodingResolver;
import io.inverno.mod.http.server.internal.http2.Http2Exchange;
import io.inverno.mod.http.server.internal.http2.Http2RequestHeaders;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import reactor.core.publisher.Sinks;

public class Http2ChannelHandler
extends Http2ConnectionHandler
implements Http2FrameListener,
Http2Connection.Listener {
    private final HttpServerConfiguration configuration;
    private final ExchangeHandler<Exchange> rootHandler;
    private final ExchangeHandler<ErrorExchange<Throwable>> errorHandler;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private final Http2ContentEncodingResolver contentEncodingResolver;
    private final IntObjectMap<Http2Exchange> serverStreams;

    public Http2ChannelHandler(HttpServerConfiguration configuration, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, ExchangeHandler<Exchange> rootHandler, ExchangeHandler<ErrorExchange<Throwable>> errorHandler, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, Http2ContentEncodingResolver contentEncodingResolver) {
        super(decoder, encoder, initialSettings);
        this.configuration = configuration;
        this.rootHandler = rootHandler;
        this.errorHandler = errorHandler;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.contentEncodingResolver = contentEncodingResolver;
        this.serverStreams = new IntObjectHashMap();
        this.connection().addListener((Http2Connection.Listener)this);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void onError(ChannelHandlerContext ctx, boolean outbound, Throwable cause) {
        super.onError(ctx, outbound, cause);
        ctx.close();
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        int processed = data.readableBytes() + padding;
        Http2Exchange serverStream = (Http2Exchange)this.serverStreams.get(streamId);
        if (serverStream != null) {
            serverStream.request().data().ifPresent(sink -> {
                data.retain();
                if (sink.tryEmitNext((Object)data) != Sinks.EmitResult.OK) {
                    data.release();
                }
            });
            if (endOfStream) {
                serverStream.request().data().ifPresent(sink -> sink.tryEmitComplete());
            }
        } else {
            throw new IllegalStateException("Unable to push data to unmanaged stream " + streamId);
        }
        return processed;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, final int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        Http2Exchange exchange = (Http2Exchange)this.serverStreams.get(streamId);
        if (exchange == null) {
            Http2Exchange streamExchange = new Http2Exchange(ctx, this.connection().stream(streamId), headers, this.encoder(), this.headerService, this.parameterConverter, this.urlEncodedBodyDecoder, this.multipartBodyDecoder, this.rootHandler, this.errorHandler);
            if (this.configuration.compression_enabled()) {
                String acceptEncoding;
                String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
                if (acceptEncoding != null) {
                    streamExchange.setContentEncoding(this.contentEncodingResolver.resolve(acceptEncoding));
                }
            }
            this.serverStreams.put(streamId, (Object)streamExchange);
            if (endOfStream) {
                streamExchange.request().data().ifPresent(sink -> sink.tryEmitComplete());
            }
            streamExchange.start(new AbstractExchange.Handler(){

                @Override
                public void exchangeError(ChannelHandlerContext ctx, Throwable t) {
                    Http2ChannelHandler.this.resetStream(ctx, streamId, Http2Error.INTERNAL_ERROR.code(), ctx.voidPromise());
                }
            });
        } else {
            ((Http2RequestHeaders)exchange.request().headers()).getUnderlyingHeaders().add((Headers)headers);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        Http2Exchange serverStream = (Http2Exchange)this.serverStreams.remove(streamId);
        if (serverStream != null) {
            serverStream.dispose();
        }
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        if (this.configuration.decompression_enabled()) {
            this.decoder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(this.decoder().connection(), (Http2FrameListener)this));
        } else {
            this.decoder().frameListener((Http2FrameListener)this);
        }
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
    }

    public void onStreamAdded(Http2Stream stream) {
    }

    public void onStreamActive(Http2Stream stream) {
    }

    public void onStreamHalfClosed(Http2Stream stream) {
    }

    public void onStreamClosed(Http2Stream stream) {
    }

    public void onStreamRemoved(Http2Stream stream) {
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
    }
}

