/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.http1x.Http1xChannelHandler;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import java.util.function.Supplier;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class Http1xChannelHandlerFactory
implements Supplier<Http1xChannelHandler> {
    private ExchangeHandler<Exchange> rootHandler;
    private ExchangeHandler<ErrorExchange<Throwable>> errorHandler;
    private HeaderService headerService;
    private ObjectConverter<String> parameterConverter;
    private MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private MultipartDecoder<Part> multipartBodyDecoder;

    public Http1xChannelHandlerFactory(ExchangeHandler<Exchange> rootHandler, ExchangeHandler<ErrorExchange<Throwable>> errorHandler, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        this.rootHandler = rootHandler;
        this.errorHandler = errorHandler;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
    }

    @Override
    public Http1xChannelHandler get() {
        return new Http1xChannelHandler(this.rootHandler, this.errorHandler, this.headerService, this.parameterConverter, this.urlEncodedBodyDecoder, this.multipartBodyDecoder);
    }
}

