/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.header.Cookie;
import io.inverno.mod.http.base.header.CookieParameter;
import io.inverno.mod.http.base.internal.header.GenericCookieParameter;
import io.inverno.mod.http.server.RequestCookies;
import io.inverno.mod.http.server.RequestHeaders;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GenericRequestCookies
implements RequestCookies {
    private Map<String, List<CookieParameter>> pairs;

    public GenericRequestCookies(RequestHeaders requestHeaders, ObjectConverter<String> parameterConverter) {
        this.pairs = requestHeaders.getAllHeader("cookie").stream().flatMap(cookieHeader -> cookieHeader.getPairs().values().stream().flatMap(Collection::stream)).map(cookie -> {
            if (cookie instanceof CookieParameter) {
                return cookie;
            }
            return new GenericCookieParameter(parameterConverter, cookie.getName(), cookie.getValue());
        }).collect(Collectors.groupingBy(Cookie::getName));
    }

    @Override
    public boolean contains(String name) {
        return this.pairs.containsKey(name);
    }

    @Override
    public Set<String> getNames() {
        return this.pairs.keySet();
    }

    @Override
    public Optional<CookieParameter> get(String name) {
        return Optional.ofNullable(this.getAll(name)).map(cookies -> {
            if (!cookies.isEmpty()) {
                return (CookieParameter)cookies.get(0);
            }
            return null;
        });
    }

    @Override
    public List<CookieParameter> getAll(String name) {
        List<CookieParameter> cookiePairs = this.pairs.get(name);
        return cookiePairs != null ? cookiePairs : List.of();
    }

    @Override
    public Map<String, List<CookieParameter>> getAll() {
        return this.pairs;
    }
}

