/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server;

import io.inverno.core.v1.Module;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.NetService;
import io.inverno.mod.base.resource.ResourceService;
import io.inverno.mod.http.base.Base;
import io.inverno.mod.http.base.header.HeaderCodec;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.HttpServerConfigurationLoader;
import io.inverno.mod.http.server.internal.ErrorHandler;
import io.inverno.mod.http.server.internal.HttpChannelConfigurer;
import io.inverno.mod.http.server.internal.HttpChannelInitializer;
import io.inverno.mod.http.server.internal.HttpServer;
import io.inverno.mod.http.server.internal.ParameterConverter;
import io.inverno.mod.http.server.internal.RootHandler;
import io.inverno.mod.http.server.internal.SslCipherSuiteFilter;
import io.inverno.mod.http.server.internal.SslContextWrapper;
import io.inverno.mod.http.server.internal.http1x.Http1xChannelHandlerFactory;
import io.inverno.mod.http.server.internal.http2.Http2ChannelHandlerFactory;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.inverno.mod.http.server.internal.multipart.MultipartFormDataBodyDecoder;
import io.inverno.mod.http.server.internal.multipart.UrlEncodedBodyDecoder;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public final class Server
extends Module {
    private Base base = (Base)this.with((Module.ModuleLinker)new Base.Linker(Map.ofEntries(Map.entry("headerCodecs", Optional.of(() -> new Module.BeanAggregator().add((Collection)headerCodecs.orElse(() -> null).get()).toList())), Map.entry("parameterConverter", Optional.of(() -> (ObjectConverter)this.parameterConverter.get())))));
    private Module.Bean<ExchangeHandler<ErrorExchange<Throwable>>> errorHandler;
    private Module.Bean<Http1xChannelHandlerFactory> http1xChannelHandlerFactory;
    private Module.Bean<Http2ChannelHandlerFactory> http2ChannelHandlerFactory;
    private Module.Bean<HttpChannelConfigurer> httpChannelConfigurer;
    private Module.Bean<HttpChannelInitializer> httpChannelInitializer;
    private Module.Bean<HttpServer> httpServer;
    private Module.Bean<HttpServerConfiguration> httpServerConfiguration;
    private Module.Bean<MultipartFormDataBodyDecoder> multipartFormDataBodyDecoder;
    private Module.Bean<ObjectConverter<String>> parameterConverter;
    private Module.Bean<ExchangeHandler<Exchange>> rootHandler;
    private Module.Bean<SslCipherSuiteFilter> sslCipherSuiteFilter;
    private Module.Bean<SslContext> sslContextWrapper;
    private Module.Bean<UrlEncodedBodyDecoder> urlEncodedBodyDecoder;

    private Server(@Module.Socket(name="headerCodecs", wiredTo={"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs, @Module.Socket(name="netService", wiredTo={"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Supplier<NetService> netService, @Module.Socket(name="resourceService", wiredTo={"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Supplier<ResourceService> resourceService, @Module.Socket(name="errorHandler", wiredTo={"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<ExchangeHandler<ErrorExchange<Throwable>>>> errorHandlerOverride, @Module.Socket(name="httpServerConfiguration", wiredTo={"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<HttpServerConfiguration>> httpServerConfigurationOverride, @Module.Socket(name="parameterConverter", wiredTo={"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<ObjectConverter<String>>> parameterConverterOverride, @Module.Socket(name="rootHandler", wiredTo={"multipartFormDataBodyDecoder", "parameterConverter", "httpServerConfiguration", "http2ChannelHandlerFactory", "httpChannelInitializer", "sslContextWrapper", "rootHandler", "httpChannelConfigurer", "http1xChannelHandlerFactory", "httpServer", "urlEncodedBodyDecoder", "sslCipherSuiteFilter", "errorHandler"}) Optional<Supplier<ExchangeHandler<Exchange>>> rootHandlerOverride) {
        super("io.inverno.mod.http.server");
        this.errorHandler = this.with(Module.WrapperBeanBuilder.singleton((String)"errorHandler", () -> {
            ErrorHandler errorHandler = new ErrorHandler();
            return errorHandler;
        }).override(errorHandlerOverride));
        this.http1xChannelHandlerFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"http1xChannelHandlerFactory", () -> {
            Http1xChannelHandlerFactory http1xChannelHandlerFactory = new Http1xChannelHandlerFactory((ExchangeHandler)this.rootHandler.get(), (ExchangeHandler)this.errorHandler.get(), (HeaderService)this.base.headerService(), (ObjectConverter<String>)((ObjectConverter)this.parameterConverter.get()), (MultipartDecoder)this.urlEncodedBodyDecoder.get(), (MultipartDecoder)this.multipartFormDataBodyDecoder.get());
            return http1xChannelHandlerFactory;
        }));
        this.http2ChannelHandlerFactory = this.with(Module.ModuleBeanBuilder.singleton((String)"http2ChannelHandlerFactory", () -> {
            Http2ChannelHandlerFactory http2ChannelHandlerFactory = new Http2ChannelHandlerFactory((HttpServerConfiguration)this.httpServerConfiguration.get(), (ExchangeHandler)this.rootHandler.get(), (ExchangeHandler)this.errorHandler.get(), (HeaderService)this.base.headerService(), (ObjectConverter<String>)((ObjectConverter)this.parameterConverter.get()), (MultipartDecoder)this.urlEncodedBodyDecoder.get(), (MultipartDecoder)this.multipartFormDataBodyDecoder.get());
            return http2ChannelHandlerFactory;
        }));
        this.httpChannelConfigurer = this.with(Module.ModuleBeanBuilder.singleton((String)"httpChannelConfigurer", () -> {
            HttpChannelConfigurer httpChannelConfigurer = new HttpChannelConfigurer((HttpServerConfiguration)this.httpServerConfiguration.get(), (NetService)netService.get(), () -> (SslContext)this.sslContextWrapper.get(), (Supplier)this.http1xChannelHandlerFactory.get(), (Supplier)this.http2ChannelHandlerFactory.get());
            return httpChannelConfigurer;
        }));
        this.httpChannelInitializer = this.with(Module.ModuleBeanBuilder.singleton((String)"httpChannelInitializer", () -> {
            HttpChannelInitializer httpChannelInitializer = new HttpChannelInitializer((HttpChannelConfigurer)this.httpChannelConfigurer.get());
            return httpChannelInitializer;
        }));
        this.httpServer = this.with((Module.ModuleBeanBuilder)((Module.ModuleBeanBuilder)Module.ModuleBeanBuilder.singleton((String)"httpServer", () -> {
            HttpServer httpServer = new HttpServer((HttpServerConfiguration)this.httpServerConfiguration.get(), (NetService)netService.get(), (ChannelInitializer<SocketChannel>)((ChannelInitializer)this.httpChannelInitializer.get()));
            return httpServer;
        }).init(HttpServer::start)).destroy(HttpServer::stop));
        this.httpServerConfiguration = this.with(Module.WrapperBeanBuilder.singleton((String)"httpServerConfiguration", () -> {
            HttpServerConfigurationLoader.Bean httpServerConfiguration = new HttpServerConfigurationLoader.Bean();
            return httpServerConfiguration;
        }).override(httpServerConfigurationOverride));
        this.multipartFormDataBodyDecoder = this.with(Module.ModuleBeanBuilder.singleton((String)"multipartFormDataBodyDecoder", () -> {
            MultipartFormDataBodyDecoder multipartFormDataBodyDecoder = new MultipartFormDataBodyDecoder((HeaderService)this.base.headerService(), (ObjectConverter<String>)((ObjectConverter)this.parameterConverter.get()));
            return multipartFormDataBodyDecoder;
        }));
        this.parameterConverter = this.with(Module.WrapperBeanBuilder.singleton((String)"parameterConverter", () -> {
            ParameterConverter parameterConverter = new ParameterConverter();
            return parameterConverter;
        }).override(parameterConverterOverride));
        this.rootHandler = this.with(Module.WrapperBeanBuilder.singleton((String)"rootHandler", () -> {
            RootHandler rootHandler = new RootHandler();
            return rootHandler;
        }).override(rootHandlerOverride));
        this.sslCipherSuiteFilter = this.with(Module.ModuleBeanBuilder.singleton((String)"sslCipherSuiteFilter", () -> {
            SslCipherSuiteFilter sslCipherSuiteFilter = new SslCipherSuiteFilter((HttpServerConfiguration)this.httpServerConfiguration.get());
            return sslCipherSuiteFilter;
        }));
        this.sslContextWrapper = this.with((Module.WrapperBeanBuilder)Module.WrapperBeanBuilder.prototype((String)"sslContextWrapper", () -> {
            SslContextWrapper sslContextWrapper = new SslContextWrapper((HttpServerConfiguration)this.httpServerConfiguration.get(), (ResourceService)resourceService.get());
            sslContextWrapper.setCipherSuiteFilter((CipherSuiteFilter)this.sslCipherSuiteFilter.get());
            return sslContextWrapper;
        }).init(SslContextWrapper::init));
        this.urlEncodedBodyDecoder = this.with(Module.ModuleBeanBuilder.singleton((String)"urlEncodedBodyDecoder", () -> {
            UrlEncodedBodyDecoder urlEncodedBodyDecoder = new UrlEncodedBodyDecoder((ObjectConverter<String>)((ObjectConverter)this.parameterConverter.get()));
            return urlEncodedBodyDecoder;
        }));
    }

    public ExchangeHandler<ErrorExchange<Throwable>> errorHandler() {
        return (ExchangeHandler)this.errorHandler.get();
    }

    private Http1xChannelHandlerFactory http1xChannelHandlerFactory() {
        return (Http1xChannelHandlerFactory)this.http1xChannelHandlerFactory.get();
    }

    private Http2ChannelHandlerFactory http2ChannelHandlerFactory() {
        return (Http2ChannelHandlerFactory)this.http2ChannelHandlerFactory.get();
    }

    private HttpChannelConfigurer httpChannelConfigurer() {
        return (HttpChannelConfigurer)this.httpChannelConfigurer.get();
    }

    private HttpChannelInitializer httpChannelInitializer() {
        return (HttpChannelInitializer)((Object)this.httpChannelInitializer.get());
    }

    private HttpServer httpServer() {
        return (HttpServer)this.httpServer.get();
    }

    public HttpServerConfiguration httpServerConfiguration() {
        return (HttpServerConfiguration)this.httpServerConfiguration.get();
    }

    private MultipartFormDataBodyDecoder multipartFormDataBodyDecoder() {
        return (MultipartFormDataBodyDecoder)this.multipartFormDataBodyDecoder.get();
    }

    private ObjectConverter<String> parameterConverter() {
        return (ObjectConverter)this.parameterConverter.get();
    }

    public ExchangeHandler<Exchange> rootHandler() {
        return (ExchangeHandler)this.rootHandler.get();
    }

    private SslCipherSuiteFilter sslCipherSuiteFilter() {
        return (SslCipherSuiteFilter)this.sslCipherSuiteFilter.get();
    }

    private SslContext sslContextWrapper() {
        return (SslContext)this.sslContextWrapper.get();
    }

    private UrlEncodedBodyDecoder urlEncodedBodyDecoder() {
        return (UrlEncodedBodyDecoder)this.urlEncodedBodyDecoder.get();
    }

    public static final class Linker
    extends Module.ModuleLinker<Server> {
        public Linker(Map<String, Object> sockets) {
            super(sockets);
        }

        protected Server link() {
            return new Server((Optional)this.sockets.get("headerCodecs"), (Supplier)this.sockets.get("netService"), (Supplier)this.sockets.get("resourceService"), (Optional)this.sockets.get("errorHandler"), (Optional)this.sockets.get("httpServerConfiguration"), (Optional)this.sockets.get("parameterConverter"), (Optional)this.sockets.get("rootHandler"));
        }
    }

    public static final class Builder
    extends Module.ModuleBuilder<Server> {
        private Optional<Supplier<List<HeaderCodec<?>>>> headerCodecs = Optional.empty();
        private Supplier<NetService> netService;
        private Supplier<ResourceService> resourceService;
        private Optional<Supplier<ExchangeHandler<ErrorExchange<Throwable>>>> errorHandler = Optional.empty();
        private Optional<Supplier<HttpServerConfiguration>> httpServerConfiguration = Optional.empty();
        private Optional<Supplier<ObjectConverter<String>>> parameterConverter = Optional.empty();
        private Optional<Supplier<ExchangeHandler<Exchange>>> rootHandler = Optional.empty();

        public Builder(NetService netService, ResourceService resourceService) {
            super(new Object[]{"netService", netService, "resourceService", resourceService});
            this.netService = () -> netService;
            this.resourceService = () -> resourceService;
        }

        protected Server doBuild() {
            return new Server(this.headerCodecs, this.netService, this.resourceService, this.errorHandler, this.httpServerConfiguration, this.parameterConverter, this.rootHandler);
        }

        public Builder setHeaderCodecs(List<HeaderCodec<?>> headerCodecs) {
            this.headerCodecs = Optional.ofNullable(headerCodecs != null ? () -> headerCodecs : null);
            return this;
        }

        public Builder setErrorHandler(ExchangeHandler<ErrorExchange<Throwable>> errorHandler) {
            this.errorHandler = Optional.ofNullable(errorHandler != null ? () -> errorHandler : null);
            return this;
        }

        public Builder setHttpServerConfiguration(HttpServerConfiguration httpServerConfiguration) {
            this.httpServerConfiguration = Optional.ofNullable(httpServerConfiguration != null ? () -> httpServerConfiguration : null);
            return this;
        }

        public Builder setParameterConverter(ObjectConverter<String> parameterConverter) {
            this.parameterConverter = Optional.ofNullable(parameterConverter != null ? () -> parameterConverter : null);
            return this;
        }

        public Builder setRootHandler(ExchangeHandler<Exchange> rootHandler) {
            this.rootHandler = Optional.ofNullable(rootHandler != null ? () -> rootHandler : null);
            return this;
        }
    }
}

