/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.internal.AbstractResponseTrailers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http2ResponseTrailers
extends AbstractResponseTrailers<Http2ResponseTrailers> {
    private final Http2Headers trailers;

    public Http2ResponseTrailers(HeaderService headerService, ObjectConverter<String> parameterConverter, boolean validate) {
        super(headerService, parameterConverter);
        this.trailers = new DefaultHttp2Headers(validate, validate, 16);
    }

    Http2Headers unwrap() {
        return this.trailers;
    }

    public Http2ResponseTrailers add(CharSequence name, CharSequence value) {
        this.trailers.add((Object)name, (Object)value);
        return this;
    }

    public Http2ResponseTrailers add(Header ... headers) {
        for (Header header : headers) {
            this.trailers.add((Object)header.getHeaderName(), (Object)this.headerService.encodeValue(header));
        }
        return this;
    }

    public Http2ResponseTrailers set(CharSequence name, CharSequence value) {
        this.trailers.set((Object)name, (Object)value);
        return this;
    }

    public Http2ResponseTrailers set(Header ... headers) {
        for (Header header : headers) {
            this.trailers.set((Object)header.getHeaderName(), (Object)this.headerService.encodeValue(header));
        }
        return this;
    }

    public Http2ResponseTrailers remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.trailers.remove((Object)name);
        }
        return this;
    }

    public boolean contains(CharSequence name) {
        return this.trailers.contains((Object)name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.trailers.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.trailers.names().stream().map(CharSequence::toString).collect(Collectors.toSet());
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable((CharSequence)this.trailers.get((Object)name)).map(Object::toString);
    }

    public List<String> getAll(CharSequence name) {
        return this.trailers.getAll((Object)name).stream().map(CharSequence::toString).collect(Collectors.toList());
    }

    public List<Map.Entry<String, String>> getAll() {
        LinkedList<Map.Entry<String, String>> result = new LinkedList<Map.Entry<String, String>>();
        this.trailers.forEach(e -> result.add(Map.entry(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.trailers.getAll((Object)name).stream().map(value -> new GenericParameter(name.toString(), value.toString(), this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        this.trailers.forEach(e -> result.add((Parameter)new GenericParameter(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString(), this.parameterConverter)));
        return result;
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.trailers.getAll((Object)name).stream().map(value -> this.headerService.decode(name.toString(), value.toString())).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        LinkedList<Header> result = new LinkedList<Header>();
        this.trailers.forEach(e -> result.add(this.headerService.decode(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }
}

