/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.internal.AbstractResponseHeaders;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http2ResponseHeaders
extends AbstractResponseHeaders<Http2ResponseHeaders> {
    private final Http2Headers headers;

    public Http2ResponseHeaders(HeaderService headerService, ObjectConverter<String> parameterConverter, boolean validate) {
        super(headerService, parameterConverter);
        this.headers = new DefaultHttp2Headers(validate, validate, 16);
        this.headers.set((Object)Http2Headers.PseudoHeaderName.STATUS.value(), (Object)"200");
    }

    Http2Headers unwrap() {
        return this.headers;
    }

    @Override
    public Http2ResponseHeaders status(Status status) {
        return this.status(status.getCode());
    }

    @Override
    public Http2ResponseHeaders status(int status) {
        this.headers.setInt((Object)Http2Headers.PseudoHeaderName.STATUS.value(), status);
        return this;
    }

    public Status getStatus() throws IllegalArgumentException {
        return Status.valueOf((int)this.getStatusCode());
    }

    public int getStatusCode() {
        return this.headers.getInt((Object)Http2Headers.PseudoHeaderName.STATUS.value());
    }

    @Override
    public Http2ResponseHeaders contentType(String contentType) {
        this.headers.set((Object)"content-type", (Object)contentType);
        return this;
    }

    public String getContentType() {
        CharSequence value = (CharSequence)this.headers.get((Object)"content-type");
        return value != null ? value.toString() : null;
    }

    public Headers.ContentType getContentTypeHeader() {
        return this.getHeader("content-type").orElse(null);
    }

    @Override
    public Http2ResponseHeaders contentLength(long contentLength) {
        this.headers.setLong((Object)"content-length", contentLength);
        return this;
    }

    public Long getContentLength() {
        return this.headers.getLong((Object)"content-length");
    }

    @Override
    public Http2ResponseHeaders add(CharSequence name, CharSequence value) {
        this.headers.add((Object)name, (Object)value);
        return this;
    }

    @Override
    public Http2ResponseHeaders add(Header ... headers) {
        for (Header header : headers) {
            this.headers.add((Object)header.getHeaderName(), (Object)this.headerService.encodeValue(header));
        }
        return this;
    }

    @Override
    public Http2ResponseHeaders set(CharSequence name, CharSequence value) {
        this.headers.set((Object)name, (Object)value);
        return this;
    }

    @Override
    public Http2ResponseHeaders set(Header ... headers) {
        for (Header header : headers) {
            this.headers.set((Object)header.getHeaderName(), (Object)this.headerService.encodeValue(header));
        }
        return this;
    }

    @Override
    public Http2ResponseHeaders remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.headers.remove((Object)name);
        }
        return this;
    }

    public boolean contains(CharSequence name) {
        return this.headers.contains((Object)name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.headers.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.headers.names().stream().map(CharSequence::toString).collect(Collectors.toSet());
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable((CharSequence)this.headers.get((Object)name)).map(Object::toString);
    }

    public List<String> getAll(CharSequence name) {
        return this.headers.getAll((Object)name).stream().map(CharSequence::toString).collect(Collectors.toList());
    }

    public List<Map.Entry<String, String>> getAll() {
        LinkedList<Map.Entry<String, String>> result = new LinkedList<Map.Entry<String, String>>();
        this.headers.forEach(e -> result.add(Map.entry(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.headers.getAll((Object)name).stream().map(value -> new GenericParameter(name.toString(), value.toString(), this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        this.headers.forEach(e -> result.add((Parameter)new GenericParameter(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString(), this.parameterConverter)));
        return result;
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.headers.getAll((Object)name).stream().map(value -> this.headerService.decode(name.toString(), value.toString())).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        LinkedList<Header> result = new LinkedList<Header>();
        this.headers.forEach(e -> result.add(this.headerService.decode(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }
}

