/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.internal.AbstractResponse;
import io.inverno.mod.http.server.internal.http2.Http2ConnectionStream;
import io.inverno.mod.http.server.internal.http2.Http2ResponseBody;
import io.inverno.mod.http.server.internal.http2.Http2ResponseHeaders;
import io.inverno.mod.http.server.internal.http2.Http2ResponseTrailers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;

class Http2Response
extends AbstractResponse<Http2ResponseHeaders, Http2ResponseBody, Http2ResponseTrailers, Http2Response> {
    private final boolean validateHeaders;
    private final Http2ConnectionStream connectionStream;
    private final Http2ResponseBody body;
    private Http2ResponseTrailers trailers;
    private Disposable disposable;

    public Http2Response(HeaderService headerService, ObjectConverter<String> parameterConverter, boolean validateHeaders, Http2ConnectionStream connectionStream, boolean head) {
        super(headerService, parameterConverter, head, new Http2ResponseHeaders(headerService, parameterConverter, validateHeaders));
        this.validateHeaders = validateHeaders;
        this.connectionStream = connectionStream;
        this.body = new Http2ResponseBody((Http2ResponseHeaders)this.headers);
    }

    @Override
    public void send() {
        if (this.connectionStream.executor().inEventLoop()) {
            if (!this.head) {
                this.body.getData().subscribe((Subscriber)(this.body.getData() instanceof Mono ? new MonoBodyDataSubscriber() : new BodyDataSubscriber()));
            } else if (this.trailers == null) {
                this.connectionStream.writeHeaders(((Http2ResponseHeaders)this.headers).unwrap(), 0, true);
                ((Http2ResponseHeaders)this.headers).setWritten();
            } else {
                this.connectionStream.writeHeaders(((Http2ResponseHeaders)this.headers).unwrap(), 0, false);
                ((Http2ResponseHeaders)this.headers).setWritten();
                this.connectionStream.writeHeaders(this.trailers.unwrap(), 0, true);
                this.trailers.setWritten();
            }
        } else {
            this.connectionStream.executor().execute(this::send);
        }
    }

    final void dispose(Throwable cause) {
        if (this.disposable != null) {
            this.disposable.dispose();
            this.disposable = null;
        }
    }

    @Override
    public Http2Response sendContinue() throws IllegalStateException {
        if (this.isHeadersWritten()) {
            throw new IllegalStateException("Headers already written");
        }
        if (this.connectionStream.executor().inEventLoop()) {
            this.connectionStream.writeHeaders(new DefaultHttp2Headers().status((CharSequence)"100"), 0, false);
        } else {
            this.connectionStream.executor().execute(this::sendContinue);
        }
        return this;
    }

    @Override
    public Http2ResponseBody body() {
        return this.body;
    }

    @Override
    public Http2ResponseTrailers trailers() {
        if (this.trailers == null) {
            this.trailers = new Http2ResponseTrailers(this.headerService, (ObjectConverter<String>)this.parameterConverter, this.validateHeaders);
        }
        return this.trailers;
    }

    private class MonoBodyDataSubscriber
    extends BaseSubscriber<ByteBuf> {
        private ByteBuf data;

        private MonoBodyDataSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            Http2Response.this.disposable = this;
            subscription.request(1L);
        }

        protected void hookOnNext(ByteBuf value) {
            Http2Response.this.transferedLength += value.readableBytes();
            this.data = value;
        }

        protected void hookOnComplete() {
            if (!Http2Response.this.connectionStream.isReset()) {
                if (!((Http2ResponseHeaders)Http2Response.this.headers).contains("content-length")) {
                    ((Http2ResponseHeaders)Http2Response.this.headers).contentLength(Http2Response.this.transferedLength);
                }
                if (this.data == null) {
                    if (Http2Response.this.trailers == null) {
                        Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, true);
                        ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                    } else {
                        Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, false);
                        ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                        Http2Response.this.connectionStream.writeHeaders(Http2Response.this.trailers.unwrap(), 0, true);
                        Http2Response.this.trailers.setWritten();
                    }
                } else if (Http2Response.this.trailers == null) {
                    Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, false);
                    ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                    Http2Response.this.connectionStream.writeData(this.data, 0, true);
                } else {
                    Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, false);
                    ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                    Http2Response.this.connectionStream.writeData(this.data, 0, false);
                    Http2Response.this.connectionStream.writeHeaders(Http2Response.this.trailers.unwrap(), 0, true);
                    Http2Response.this.trailers.setWritten();
                }
            }
            Http2Response.this.connectionStream.onExchangeComplete();
        }

        protected void hookOnError(Throwable throwable) {
            if (!Http2Response.this.connectionStream.isReset()) {
                Http2Response.this.connectionStream.onExchangeError(throwable);
            }
        }
    }

    private class BodyDataSubscriber
    extends BaseSubscriber<ByteBuf> {
        private ByteBuf singleChunk;
        private boolean many;

        private BodyDataSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            Http2Response.this.disposable = this;
            subscription.request(Long.MAX_VALUE);
        }

        protected void hookOnNext(ByteBuf value) {
            if (!Http2Response.this.connectionStream.isReset()) {
                Http2Response.this.transferedLength += value.readableBytes();
                if (!this.many && this.singleChunk == null) {
                    this.singleChunk = value;
                } else {
                    this.many = true;
                    if (((Http2ResponseHeaders)Http2Response.this.headers).isWritten()) {
                        Http2Response.this.connectionStream.writeData(value, 0, false);
                    } else {
                        Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, false);
                        ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                        Http2Response.this.connectionStream.writeData(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.singleChunk, value}), 0, false);
                        this.singleChunk = null;
                    }
                }
            }
        }

        protected void hookOnComplete() {
            if (!Http2Response.this.connectionStream.isReset()) {
                if (this.many) {
                    if (Http2Response.this.trailers == null) {
                        Http2Response.this.connectionStream.writeData(Unpooled.EMPTY_BUFFER, 0, true);
                    } else {
                        Http2Response.this.connectionStream.writeHeaders(Http2Response.this.trailers.unwrap(), 0, true);
                        Http2Response.this.trailers.setWritten();
                    }
                } else {
                    if (!((Http2ResponseHeaders)Http2Response.this.headers).contains("content-length")) {
                        ((Http2ResponseHeaders)Http2Response.this.headers).contentLength(Http2Response.this.transferedLength);
                    }
                    if (this.singleChunk == null) {
                        if (Http2Response.this.trailers == null) {
                            Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, true);
                            ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                        } else {
                            Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, false);
                            ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                            Http2Response.this.connectionStream.writeHeaders(Http2Response.this.trailers.unwrap(), 0, true);
                            Http2Response.this.trailers.setWritten();
                        }
                    } else if (Http2Response.this.trailers == null) {
                        Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, false);
                        ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                        Http2Response.this.connectionStream.writeData(this.singleChunk, 0, true);
                    } else {
                        Http2Response.this.connectionStream.writeHeaders(((Http2ResponseHeaders)Http2Response.this.headers).unwrap(), 0, false);
                        ((Http2ResponseHeaders)Http2Response.this.headers).setWritten();
                        Http2Response.this.connectionStream.writeData(this.singleChunk, 0, false);
                        Http2Response.this.connectionStream.writeHeaders(Http2Response.this.trailers.unwrap(), 0, true);
                        Http2Response.this.trailers.setWritten();
                    }
                }
            }
            Http2Response.this.connectionStream.onExchangeComplete();
        }

        protected void hookOnError(Throwable throwable) {
            if (!Http2Response.this.connectionStream.isReset()) {
                Http2Response.this.connectionStream.onExchangeError(throwable);
            }
        }
    }
}

