/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.internal.AbstractRequestHeaders;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http2RequestHeaders
extends AbstractRequestHeaders {
    private final Http2Headers headers;

    public Http2RequestHeaders(HeaderService headerService, ObjectConverter<String> parameterConverter, Http2Headers headers) {
        super(headerService, parameterConverter);
        this.headers = headers;
    }

    Http2Headers unwrap() {
        return this.headers;
    }

    public String getContentType() {
        return this.get("content-type").orElse(null);
    }

    public Headers.ContentType getContentTypeHeader() {
        return this.getHeader("content-type").orElse(null);
    }

    public Long getContentLength() {
        return this.headers.getLong((Object)"content-length");
    }

    public boolean contains(CharSequence name) {
        return this.headers.contains((Object)name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.headers.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.headers.names().stream().map(CharSequence::toString).collect(Collectors.toSet());
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable((CharSequence)this.headers.get((Object)name)).map(Object::toString);
    }

    public List<String> getAll(CharSequence name) {
        return this.headers.getAll((Object)name).stream().map(CharSequence::toString).collect(Collectors.toList());
    }

    public List<Map.Entry<String, String>> getAll() {
        LinkedList<Map.Entry<String, String>> result = new LinkedList<Map.Entry<String, String>>();
        this.headers.forEach(e -> result.add(Map.entry(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.headers.getAll((Object)name).stream().map(value -> new GenericParameter(name.toString(), value.toString(), this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        this.headers.forEach(e -> result.add((Parameter)new GenericParameter(((CharSequence)e.getValue()).toString(), ((CharSequence)e.getValue()).toString(), this.parameterConverter)));
        return result;
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.headers.getAll((Object)name).stream().map(value -> this.headerService.decode(name.toString(), value.toString())).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        LinkedList<Header> result = new LinkedList<Header>();
        this.headers.forEach(e -> result.add(this.headerService.decode(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }
}

