/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.AbstractRequest;
import io.inverno.mod.http.server.internal.http2.Http2ConnectionStream;
import io.inverno.mod.http.server.internal.http2.Http2RequestBody;
import io.inverno.mod.http.server.internal.http2.Http2RequestHeaders;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.handler.codec.http2.Http2Headers;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Optional;

class Http2Request
extends AbstractRequest<Http2RequestHeaders, Http2RequestBody> {
    private final Http2ConnectionStream connectionStream;
    private String scheme;
    private Method method;
    private String path;
    private String authority;

    public Http2Request(HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, Http2ConnectionStream connectionStream, Http2Headers headers) {
        super(parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder, new Http2RequestHeaders(headerService, parameterConverter, headers));
        this.connectionStream = connectionStream;
    }

    public String getScheme() {
        if (this.scheme == null) {
            this.scheme = ((Http2RequestHeaders)this.headers).get(":scheme").orElse(null);
        }
        return this.scheme;
    }

    public SocketAddress getLocalAddress() {
        return this.connectionStream.getLocalAddress();
    }

    public Optional<Certificate[]> getLocalCertificates() {
        return this.connectionStream.getLocalCertificates();
    }

    public SocketAddress getRemoteAddress() {
        return this.connectionStream.getRemoteAddress();
    }

    public Optional<Certificate[]> getRemoteCertificates() {
        return this.connectionStream.getRemoteCertificates();
    }

    public Method getMethod() {
        if (this.method == null) {
            this.method = ((Http2RequestHeaders)this.headers).get(":method").map(methodString -> {
                try {
                    return Method.valueOf((String)methodString);
                }
                catch (IllegalArgumentException e) {
                    return Method.UNKNOWN;
                }
            }).orElse(null);
        }
        return this.method;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = ((Http2RequestHeaders)this.headers).get(":path").orElse(null);
        }
        return this.path;
    }

    public String getAuthority() {
        if (this.authority == null) {
            this.authority = ((Http2RequestHeaders)this.headers).get(":authority").orElse(null);
        }
        return this.authority;
    }

    @Override
    public Optional<Http2RequestBody> body() {
        if (this.body == null) {
            switch (this.getMethod()) {
                case POST: 
                case PUT: 
                case PATCH: 
                case DELETE: {
                    this.body = new Http2RequestBody((MultipartDecoder<Parameter>)this.urlEncodedBodyDecoder, (MultipartDecoder<Part>)this.multipartBodyDecoder, (Http2RequestHeaders)this.headers);
                }
            }
        }
        return Optional.ofNullable((Http2RequestBody)this.body);
    }
}

