/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ResetStreamException;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.http2.AbstractHttp2Exchange;
import io.inverno.mod.http.server.internal.http2.Http2ConnectionStream;
import io.inverno.mod.http.server.internal.http2.Http2ErrorExchange;
import io.inverno.mod.http.server.internal.http2.Http2Request;
import io.inverno.mod.http.server.internal.http2.Http2Response;
import io.inverno.mod.http.server.internal.http2.Http2ResponseHeaders;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.inverno.mod.http.server.ws.WebSocket;
import io.inverno.mod.http.server.ws.WebSocketExchange;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.Optional;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;

class Http2Exchange
extends AbstractHttp2Exchange {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final boolean validateHeaders;
    private final ExchangeContext context;
    private final Http2Request request;
    private final Http2Response response;
    private Disposable disposable;

    public Http2Exchange(HttpServerConfiguration configuration, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, Http2ConnectionStream connectionStream, Http2Headers headers) {
        super(configuration, controller, connectionStream, headers);
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.validateHeaders = configuration.http2_validate_headers();
        this.context = controller.createContext();
        if (this.context != null) {
            this.context.init();
        }
        this.request = new Http2Request(headerService, parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder, connectionStream, headers);
        this.response = new Http2Response(headerService, parameterConverter, this.validateHeaders, connectionStream, this.head);
    }

    @Override
    public void start() {
        this.connectionStream.exchange = this;
        try {
            this.controller.defer(this).subscribe((CoreSubscriber)new ExchangeHandlerSubscriber());
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
    }

    @Override
    public void handleError(Throwable throwable) {
        if (((Http2ResponseHeaders)this.response.headers()).isWritten()) {
            this.dispose(throwable);
            this.connectionStream.resetStream(Http2Error.INTERNAL_ERROR.code());
        } else {
            this.createErrorExchange(throwable).start();
        }
    }

    @Override
    public Http2ErrorExchange createErrorExchange(Throwable throwable) {
        return new Http2ErrorExchange(this, new Http2Response(this.headerService, this.parameterConverter, this.validateHeaders, this.connectionStream, this.head), throwable);
    }

    @Override
    protected void doDispose(Throwable cause) {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        if (cause instanceof ResetStreamException && this.connectionStream.getStream().isResetSent()) {
            cause = null;
        }
        this.request.dispose(cause);
        this.response.dispose(cause);
    }

    public ExchangeContext context() {
        return this.context;
    }

    @Override
    public Http2Request request() {
        return this.request;
    }

    @Override
    public Http2Response response() {
        return this.response;
    }

    @Override
    public Optional<? extends WebSocket<ExchangeContext, ? extends WebSocketExchange<ExchangeContext>>> webSocket(String ... subProtocols) {
        return Optional.empty();
    }

    private class ExchangeHandlerSubscriber
    extends BaseSubscriber<Void> {
        private ExchangeHandlerSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            Http2Exchange.this.disposable = this;
            super.hookOnSubscribe(subscription);
        }

        protected void hookOnComplete() {
            if (!Http2Exchange.this.connectionStream.isReset()) {
                Http2Exchange.this.response.send();
            }
        }

        protected void hookOnError(Throwable throwable) {
            if (!Http2Exchange.this.connectionStream.isReset()) {
                Http2Exchange.this.connectionStream.onExchangeError(throwable);
            }
        }
    }
}

