/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.internal.GenericErrorExchangeHandler;
import io.inverno.mod.http.server.internal.http2.AbstractHttp2Exchange;
import io.inverno.mod.http.server.internal.http2.Http2Exchange;
import io.inverno.mod.http.server.internal.http2.Http2Request;
import io.inverno.mod.http.server.internal.http2.Http2Response;
import io.inverno.mod.http.server.internal.http2.Http2ResponseHeaders;
import io.netty.handler.codec.http2.Http2Error;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;

class Http2ErrorExchange
extends AbstractHttp2Exchange
implements ErrorExchange<ExchangeContext> {
    private static final Logger LOGGER = LogManager.getLogger(ErrorExchange.class);
    private final Http2Exchange exchange;
    private final Http2Response response;
    private final Throwable error;
    private boolean lastResort;
    private Disposable disposable;

    public Http2ErrorExchange(Http2Exchange exchange, Http2Response response, Throwable error) {
        super(exchange);
        this.exchange = exchange;
        this.response = response;
        this.error = error;
    }

    @Override
    public void start() {
        this.connectionStream.exchange = this;
        try {
            ErrorExchangeHandlerSubscriber handlerSubscriber = new ErrorExchangeHandlerSubscriber();
            if (this.lastResort) {
                GenericErrorExchangeHandler.INSTANCE.handle(this);
                handlerSubscriber.hookOnComplete();
            } else {
                LOGGER.log(this.error instanceof HttpException && ((HttpException)this.error).getStatusCategory() != Status.Category.SERVER_ERROR ? Level.WARN : Level.ERROR, "Exchange processing error", this.error);
                this.controller.defer(this).subscribe((CoreSubscriber)handlerSubscriber);
            }
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
    }

    @Override
    public void handleError(Throwable throwable) {
        if (this.lastResort || ((Http2ResponseHeaders)this.response.headers()).isWritten()) {
            throwable.addSuppressed(this.error);
            LOGGER.error("Fatal exchange processing error", throwable);
            this.dispose(throwable);
            this.connectionStream.resetStream(Http2Error.INTERNAL_ERROR.code());
        } else {
            LOGGER.error("Error handler error", throwable);
            this.createErrorExchange(throwable).start();
        }
    }

    @Override
    public Http2ErrorExchange createErrorExchange(Throwable throwable) {
        throwable.addSuppressed(this.error);
        Http2ErrorExchange errorExchange = this.exchange.createErrorExchange(throwable);
        errorExchange.lastResort = true;
        return errorExchange;
    }

    @Override
    protected void doDispose(Throwable cause) {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.exchange.request().dispose(cause);
        this.response.dispose(cause);
    }

    public ExchangeContext context() {
        return this.exchange.context();
    }

    @Override
    public Http2Request request() {
        return this.exchange.request();
    }

    @Override
    public Http2Response response() {
        return this.response;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    private class ErrorExchangeHandlerSubscriber
    extends BaseSubscriber<Void> {
        private ErrorExchangeHandlerSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            Http2ErrorExchange.this.disposable = this;
            super.hookOnSubscribe(subscription);
        }

        protected void hookOnComplete() {
            if (!Http2ErrorExchange.this.connectionStream.isReset()) {
                Http2ErrorExchange.this.response.send();
            }
        }

        protected void hookOnError(Throwable throwable) {
            if (!Http2ErrorExchange.this.connectionStream.isReset()) {
                Http2ErrorExchange.this.connectionStream.onExchangeError(throwable);
            }
        }
    }
}

