/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.http.server.internal.http2.AbstractHttp2Exchange;
import io.inverno.mod.http.server.internal.http2.Http2Connection;
import io.inverno.mod.http.server.internal.http2.Http2Request;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Optional;

class Http2ConnectionStream {
    private final Http2Connection connection;
    private final ChannelHandlerContext channelContext;
    private final Http2Stream stream;
    AbstractHttp2Exchange exchange;
    private Long errorCode;

    public Http2ConnectionStream(Http2Connection connection, ChannelHandlerContext channelContext, Http2Stream stream) {
        this.connection = connection;
        this.channelContext = channelContext;
        this.stream = stream;
    }

    Http2Stream getStream() {
        return this.stream;
    }

    boolean isReset() {
        return this.errorCode != null;
    }

    Long getErrorCode() {
        return this.errorCode;
    }

    void setErrorCode(long errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
        }
    }

    public EventExecutor executor() {
        return this.channelContext.executor();
    }

    public ChannelPromise newPromise() {
        return this.channelContext.newPromise();
    }

    public ChannelPromise voidPromise() {
        return this.channelContext.voidPromise();
    }

    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    public Optional<Certificate[]> getLocalCertificates() {
        return this.connection.getLocalCertificates();
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public Optional<Certificate[]> getRemoteCertificates() {
        return this.connection.getRemoteCertificates();
    }

    public void resetStream(long errorCode) {
        this.resetStream(errorCode, this.channelContext.voidPromise());
    }

    public void resetStream(long errorCode, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.setErrorCode(errorCode);
            this.connection.resetStream(this.channelContext, this.stream.id(), errorCode, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.resetStream(errorCode, promise));
        }
    }

    public void writeHeaders(Http2Headers headers, int padding, boolean endStream) {
        this.writeHeaders(headers, padding, endStream, this.channelContext.voidPromise());
    }

    public void writeHeaders(Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.connection.encoder().writeHeaders(this.channelContext, this.stream.id(), headers, padding, endStream, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.writeHeaders(headers, padding, endStream, promise));
        }
    }

    public void writeHeaders(Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        this.writeHeaders(headers, streamDependency, weight, exclusive, padding, endStream, this.channelContext.voidPromise());
    }

    public void writeHeaders(Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.connection.encoder().writeHeaders(this.channelContext, this.stream.id(), headers, streamDependency, weight, exclusive, padding, endStream, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.writeHeaders(headers, streamDependency, weight, exclusive, padding, endStream, promise));
        }
    }

    public void writeData(ByteBuf data, int padding, boolean endStream) {
        this.writeData(data, padding, endStream, this.channelContext.voidPromise());
    }

    public void writeData(ByteBuf data, int padding, boolean endStream, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.connection.encoder().writeData(this.channelContext, this.stream.id(), data, padding, endStream, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.writeData(data, padding, endStream, promise));
        }
    }

    public void writePriority(int streamDependency, short weight, boolean exclusive) {
        this.writePriority(streamDependency, weight, exclusive, this.channelContext.voidPromise());
    }

    public void writePriority(int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.connection.encoder().writePriority(this.channelContext, this.stream.id(), streamDependency, weight, exclusive, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.writePriority(streamDependency, weight, exclusive, promise));
        }
    }

    public void writeRstStream(long errorCode) {
        this.writeRstStream(errorCode, this.channelContext.voidPromise());
    }

    public void writeRstStream(long errorCode, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.connection.encoder().writeRstStream(this.channelContext, this.stream.id(), errorCode, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.writeRstStream(errorCode, promise));
        }
    }

    public void writePushPromise(int promisedStreamId, Http2Headers headers, int padding) {
        this.writePushPromise(promisedStreamId, headers, padding, this.channelContext.voidPromise());
    }

    public void writePushPromise(int promisedStreamId, Http2Headers headers, int padding, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.connection.encoder().writePushPromise(this.channelContext, this.stream.id(), promisedStreamId, headers, padding, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.writePushPromise(promisedStreamId, headers, padding, promise));
        }
    }

    public void writeWindowUpdate(int windowSizeIncrement) {
        this.writeWindowUpdate(windowSizeIncrement, this.channelContext.voidPromise());
    }

    public void writeWindowUpdate(int windowSizeIncrement, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.connection.encoder().writeWindowUpdate(this.channelContext, this.stream.id(), windowSizeIncrement, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.writeWindowUpdate(windowSizeIncrement, promise));
        }
    }

    public void writeFrame(byte frameType, Http2Flags flags, ByteBuf payload) {
        this.writeFrame(frameType, flags, payload, this.channelContext.voidPromise());
    }

    public void writeFrame(byte frameType, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            this.connection.encoder().writeFrame(this.channelContext, frameType, this.stream.id(), flags, payload, promise);
            this.flush();
        } else {
            this.channelContext.executor().execute(() -> this.writeFrame(frameType, flags, payload, promise));
        }
    }

    private void flush() {
        if (!this.connection.read) {
            this.channelContext.channel().flush();
        }
    }

    public void onExchangeComplete() {
        if (this.channelContext.executor().inEventLoop()) {
            ((Http2Request)this.exchange.request()).dispose(null);
        } else {
            this.channelContext.executor().execute(this::onExchangeComplete);
        }
    }

    public void onExchangeError(Throwable error) {
        if (this.channelContext.executor().inEventLoop()) {
            this.exchange.handleError(error);
        } else {
            this.channelContext.executor().execute(() -> this.onExchangeError(error));
        }
    }
}

