/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpVersion;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.HttpServerException;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ResetStreamException;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.HttpConnection;
import io.inverno.mod.http.server.internal.http2.Http2ConnectionStream;
import io.inverno.mod.http.server.internal.http2.Http2ContentEncodingResolver;
import io.inverno.mod.http.server.internal.http2.Http2Exchange;
import io.inverno.mod.http.server.internal.http2.Http2Request;
import io.inverno.mod.http.server.internal.http2.Http2RequestBody;
import io.inverno.mod.http.server.internal.http2.Http2RequestHeaders;
import io.inverno.mod.http.server.internal.http2.Http2ResponseHeaders;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class Http2Connection
extends Http2ConnectionHandler
implements HttpConnection,
Http2FrameListener,
Http2Connection.Listener {
    private static final Logger LOGGER = LogManager.getLogger(HttpConnection.class);
    private final HttpServerConfiguration configuration;
    private final ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private final Http2ContentEncodingResolver contentEncodingResolver;
    private final IntObjectMap<Http2ConnectionStream> serverStreams;
    private ChannelHandlerContext channelContext;
    private boolean tls;
    boolean read;
    private Sinks.One<Void> shutdownSink;
    private Mono<Void> shutdown;
    private Sinks.One<Void> gracefulShutdownSink;
    private Mono<Void> gracefulShutdown;
    private boolean closing;
    private boolean closed;

    Http2Connection(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, HttpServerConfiguration configuration, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, Http2ContentEncodingResolver contentEncodingResolver) {
        super(decoder, encoder, initialSettings);
        this.configuration = configuration;
        this.controller = controller;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.contentEncodingResolver = contentEncodingResolver;
        this.serverStreams = new IntObjectHashMap();
    }

    @Override
    public boolean isTls() {
        return this.tls;
    }

    @Override
    public HttpVersion getProtocol() {
        return HttpVersion.HTTP_2_0;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channelContext.channel().localAddress();
    }

    @Override
    public Optional<Certificate[]> getLocalCertificates() {
        return Optional.ofNullable((SslHandler)this.channelContext.pipeline().get(SslHandler.class)).map(handler -> handler.engine().getSession().getLocalCertificates()).filter(certificates -> ((Certificate[])certificates).length > 0);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channelContext.channel().remoteAddress();
    }

    @Override
    public Optional<Certificate[]> getRemoteCertificates() {
        return Optional.ofNullable((SslHandler)this.channelContext.pipeline().get(SslHandler.class)).map(handler -> {
            try {
                return handler.engine().getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                return null;
            }
        }).filter(certificates -> ((Certificate[])certificates).length > 0);
    }

    @Override
    public synchronized Mono<Void> shutdown() {
        if (this.shutdownSink == null) {
            this.shutdownSink = Sinks.one();
            this.shutdown = this.shutdownSink.asMono().doOnSubscribe(ign -> {
                if (!this.closing || this.gracefulShutdownSink != null && this.gracefulShutdownSink.currentSubscriberCount() > 0) {
                    this.closing = true;
                    this.goAway(this.channelContext, this.connection().remote().lastStreamCreated(), Http2Error.NO_ERROR.code(), Unpooled.EMPTY_BUFFER, this.channelContext.voidPromise());
                    this.flush(this.channelContext);
                    this.channelContext.close().addListener(future -> {
                        if (future.isSuccess()) {
                            this.shutdownSink.tryEmitEmpty();
                        } else {
                            this.shutdownSink.tryEmitError(future.cause());
                        }
                    });
                }
            }).subscribeOn(Schedulers.fromExecutor((Executor)this.channelContext.executor()));
        }
        return this.shutdown;
    }

    @Override
    public synchronized Mono<Void> shutdownGracefully() {
        if (this.gracefulShutdownSink == null) {
            this.gracefulShutdownSink = Sinks.one();
            this.gracefulShutdown = this.gracefulShutdownSink.asMono().doOnSubscribe(ign -> {
                if (!this.closing) {
                    this.closing = true;
                }
                ChannelPromise closePromise = this.channelContext.newPromise().addListener(future -> {
                    if (future.isSuccess()) {
                        this.gracefulShutdownSink.tryEmitEmpty();
                    } else {
                        this.gracefulShutdownSink.tryEmitError(future.cause());
                    }
                });
                try {
                    this.close(this.channelContext, closePromise);
                }
                catch (Exception e) {
                    this.gracefulShutdownSink.tryEmitError((Throwable)e);
                }
            }).subscribeOn(Schedulers.fromExecutor((Executor)this.channelContext.executor()));
        }
        return this.gracefulShutdown;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channelContext = ctx;
        this.connection().addListener((Http2Connection.Listener)this);
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.tls = ctx.pipeline().get(SslHandler.class) != null;
        super.channelActive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)evt;
            FullHttpRequest request = upgradeEvent.upgradeRequest();
            String host = request.headers().get("host");
            request.headers().remove("http2-settings").remove("host");
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.method((CharSequence)request.method().name()).path((CharSequence)request.uri()).scheme((CharSequence)"http");
            if (host != null) {
                headers.authority((CharSequence)host);
            }
            request.headers().forEach(header -> headers.add((Object)((String)header.getKey()).toLowerCase(), (Object)((CharSequence)header.getValue())));
            boolean endStream = request.content() == null || !request.content().isReadable();
            this.onHeadersRead(ctx, 1, (Http2Headers)headers, 0, endStream);
            if (!endStream) {
                this.onDataRead(ctx, 1, request.content(), 0, true);
            }
        }
        try {
            super.userEventTriggered(ctx, evt);
        }
        finally {
            if (evt instanceof IdleStateEvent) {
                this.exceptionCaught(ctx, new HttpServerException("Idle timeout: " + String.valueOf(((IdleStateEvent)evt).state())));
            }
        }
    }

    public void onError(ChannelHandlerContext ctx, boolean outbound, Throwable cause) {
        super.onError(ctx, outbound, cause);
        LOGGER.debug("onError", cause);
    }

    protected void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException http2Ex) {
        super.onStreamError(ctx, outbound, cause, http2Ex);
        LOGGER.debug("onStreamError", cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.shutdown().subscribe();
        LOGGER.error("Connection error", cause);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.read = true;
        super.channelRead(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.read = false;
        super.channelReadComplete(ctx);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        Http2ConnectionStream serverStream = (Http2ConnectionStream)this.serverStreams.get(streamId);
        if (serverStream == null) {
            serverStream = new Http2ConnectionStream(this, this.channelContext, this.connection().stream(streamId));
            this.serverStreams.put(streamId, (Object)serverStream);
            Http2Exchange exchange = new Http2Exchange(this.configuration, this.controller, this.headerService, this.parameterConverter, this.urlEncodedBodyDecoder, this.multipartBodyDecoder, serverStream, headers);
            if (this.configuration.compression_enabled()) {
                String acceptEncoding;
                String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
                if (acceptEncoding != null) {
                    ((Http2ResponseHeaders)exchange.response().headers()).set("content-encoding", this.contentEncodingResolver.resolve(acceptEncoding));
                }
            }
            if (endOfStream) {
                exchange.request().body().ifPresent(body -> body.getDataSink().tryEmitComplete());
            }
            exchange.start();
        } else {
            ((Http2RequestHeaders)((Http2Request)serverStream.exchange.request()).headers()).unwrap().add((Headers)headers);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        int processed = data.readableBytes() + padding;
        Http2ConnectionStream serverStream = (Http2ConnectionStream)this.serverStreams.get(streamId);
        if (serverStream != null) {
            Http2RequestBody requestBody = (Http2RequestBody)((Http2Request)serverStream.exchange.request()).getBody();
            if (requestBody != null) {
                data.retain();
                if (requestBody.getDataSink().tryEmitNext((Object)data) != Sinks.EmitResult.OK) {
                    data.release();
                }
                if (endOfStream) {
                    requestBody.getDataSink().tryEmitComplete();
                }
            }
        } else {
            throw new IllegalStateException("Unable to push data to unmanaged stream " + streamId);
        }
        return processed;
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        Http2ConnectionStream serverStream = (Http2ConnectionStream)this.serverStreams.remove(streamId);
        if (serverStream != null) {
            serverStream.setErrorCode(errorCode);
            serverStream.exchange.dispose(new ResetStreamException(errorCode, "Stream " + streamId + " was reset (" + errorCode + ")"));
        }
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        if (this.configuration.decompression_enabled()) {
            this.decoder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(this.decoder().connection(), (Http2FrameListener)this));
        } else {
            this.decoder().frameListener((Http2FrameListener)this);
        }
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
    }

    public void onStreamAdded(Http2Stream stream) {
    }

    public void onStreamActive(Http2Stream stream) {
    }

    public void onStreamHalfClosed(Http2Stream stream) {
    }

    public void onStreamClosed(Http2Stream stream) {
        Http2ConnectionStream serverStream = (Http2ConnectionStream)this.serverStreams.remove(stream.id());
        if (serverStream != null) {
            HttpServerException cause;
            if (serverStream.isReset()) {
                cause = new ResetStreamException(serverStream.getErrorCode(), "Stream " + stream.id() + " was reset (" + serverStream.getErrorCode() + ")");
            } else {
                cause = new HttpServerException("Stream " + stream.id() + " was closed");
                serverStream.setErrorCode(Http2Error.STREAM_CLOSED.code());
            }
            serverStream.exchange.dispose(cause);
        }
    }

    public void onStreamRemoved(Http2Stream stream) {
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.shutdownGracefully().subscribe();
    }
}

