/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.http.server.internal.http2.Http2Connection;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.List;
import java.util.function.Supplier;

public class DirectH2cUpgradeHandler
extends ByteToMessageDecoder {
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer((ByteBuf)Http2CodecUtil.connectionPrefaceBuf()).asReadOnly();
    private final HttpServerUpgradeHandler.SourceCodec sourceCodec;
    private final Supplier<Http2Connection> http2ConnectionFactory;

    public DirectH2cUpgradeHandler(HttpServerUpgradeHandler.SourceCodec sourceCodec, Supplier<Http2Connection> http2ConnectionFactory) {
        this.sourceCodec = sourceCodec;
        this.http2ConnectionFactory = http2ConnectionFactory;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int prefaceLength = CONNECTION_PREFACE.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLength);
        if (!ByteBufUtil.equals((ByteBuf)CONNECTION_PREFACE, (int)CONNECTION_PREFACE.readerIndex(), (ByteBuf)in, (int)in.readerIndex(), (int)bytesRead)) {
            ctx.pipeline().remove((ChannelHandler)this);
        } else if (bytesRead == prefaceLength) {
            this.sourceCodec.upgradeFrom(ctx);
            ctx.pipeline().addAfter(ctx.name(), "connection", (ChannelHandler)this.http2ConnectionFactory.get());
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.close();
        }
    }
}

