/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpVersion;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.http2.Http2ConnectionStream;
import io.inverno.mod.http.server.internal.http2.Http2ErrorExchange;
import io.inverno.mod.http.server.internal.http2.Http2Request;
import io.inverno.mod.http.server.internal.http2.Http2Response;
import io.netty.handler.codec.http2.Http2Headers;

abstract class AbstractHttp2Exchange
extends AbstractExchange<Http2Request, Http2Response, Http2ErrorExchange> {
    protected final Http2ConnectionStream connectionStream;

    public AbstractHttp2Exchange(HttpServerConfiguration configuration, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, Http2ConnectionStream connectionStream, Http2Headers headers) {
        super(configuration, controller, Method.HEAD.name().equals(headers.get((Object)":method")));
        this.connectionStream = connectionStream;
    }

    protected AbstractHttp2Exchange(AbstractHttp2Exchange parentExchange) {
        super(parentExchange);
        this.connectionStream = parentExchange.connectionStream;
    }

    public HttpVersion getProtocol() {
        return HttpVersion.HTTP_2_0;
    }

    public final void reset(long code) {
        if (this.connectionStream.executor().inEventLoop()) {
            if (!this.connectionStream.isReset()) {
                this.connectionStream.resetStream(code);
            }
        } else {
            this.connectionStream.executor().execute(() -> this.reset(code));
        }
    }
}

