/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.internal.AbstractResponseTrailers;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http1xResponseTrailers
extends AbstractResponseTrailers<Http1xResponseTrailers> {
    private final LinkedHttpHeaders trailers;

    public Http1xResponseTrailers(HeaderService headerService, ObjectConverter<String> parameterConverter, HeadersValidator headersValidator) {
        super(headerService, parameterConverter);
        this.trailers = new LinkedHttpHeaders(headersValidator);
    }

    LinkedHttpHeaders unwrap() {
        return this.trailers;
    }

    public Http1xResponseTrailers add(CharSequence name, CharSequence value) {
        this.trailers.addCharSequence(name, value);
        return this;
    }

    public Http1xResponseTrailers add(Header ... headers) {
        for (Header header : headers) {
            this.trailers.addCharSequence((CharSequence)header.getHeaderName(), (CharSequence)this.headerService.encodeValue(header));
        }
        return this;
    }

    public Http1xResponseTrailers set(CharSequence name, CharSequence value) {
        this.trailers.setCharSequence(name, value);
        return this;
    }

    public Http1xResponseTrailers set(Header ... headers) {
        for (Header header : headers) {
            this.trailers.setCharSequence((CharSequence)header.getHeaderName(), (CharSequence)this.headerService.encodeValue(header));
        }
        return this;
    }

    public Http1xResponseTrailers remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.trailers.remove(name);
        }
        return this;
    }

    public boolean contains(CharSequence name) {
        return this.trailers.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.trailers.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.trailers.names();
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.trailers.get(name));
    }

    public List<String> getAll(CharSequence name) {
        return this.trailers.getAll(name);
    }

    public List<Map.Entry<String, String>> getAll() {
        return this.trailers.entries();
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.trailers.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        return this.trailers.entries().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        return this.getAll().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }
}

