/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.internal.AbstractResponseHeaders;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http1xResponseHeaders
extends AbstractResponseHeaders<Http1xResponseHeaders> {
    private final LinkedHttpHeaders headers;
    private int statusCode = 200;

    public Http1xResponseHeaders(HeaderService headerService, ObjectConverter<String> parameterConverter, HeadersValidator headersValidator) {
        super(headerService, parameterConverter);
        this.headers = new LinkedHttpHeaders(headersValidator);
    }

    LinkedHttpHeaders unwrap() {
        return this.headers;
    }

    @Override
    public Http1xResponseHeaders status(Status status) {
        return this.status(status.getCode());
    }

    @Override
    public Http1xResponseHeaders status(int status) {
        this.statusCode = status;
        return this;
    }

    public Status getStatus() throws IllegalArgumentException {
        return Status.valueOf((int)this.statusCode);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Http1xResponseHeaders contentType(String contentType) {
        this.headers.set((CharSequence)"content-type", (Object)contentType);
        return this;
    }

    public String getContentType() {
        return this.headers.get((CharSequence)"content-type");
    }

    public Headers.ContentType getContentTypeHeader() {
        return this.getHeader("content-type").orElse(null);
    }

    @Override
    public Http1xResponseHeaders contentLength(long contentLength) {
        this.headers.set((CharSequence)"content-length", (Object)("" + contentLength));
        return this;
    }

    public Long getContentLength() {
        return this.headers.getLong((CharSequence)"content-length");
    }

    @Override
    public Http1xResponseHeaders add(CharSequence name, CharSequence value) {
        this.headers.addCharSequence(name, value);
        return this;
    }

    @Override
    public Http1xResponseHeaders add(Header ... headers) {
        for (Header header : headers) {
            this.headers.addCharSequence((CharSequence)header.getHeaderName(), (CharSequence)this.headerService.encodeValue(header));
        }
        return this;
    }

    @Override
    public Http1xResponseHeaders set(CharSequence name, CharSequence value) {
        this.headers.setCharSequence(name, value);
        return this;
    }

    @Override
    public Http1xResponseHeaders set(Header ... headers) {
        for (Header header : headers) {
            this.headers.setCharSequence((CharSequence)header.getHeaderName(), (CharSequence)this.headerService.encodeValue(header));
        }
        return this;
    }

    @Override
    public Http1xResponseHeaders remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.headers.remove(name);
        }
        return this;
    }

    public boolean contains(CharSequence name) {
        return this.headers.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.headers.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.headers.names();
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    public List<String> getAll(CharSequence name) {
        return this.headers.getAll(name);
    }

    public List<Map.Entry<String, String>> getAll() {
        return this.headers.entries();
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.headers.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        return this.headers.entries().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        return this.getAll().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }
}

